/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.impl.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.util.UaaMapUtils;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;

public class YamlProcessor {
    private static final Log logger = LogFactory.getLog(YamlProcessor.class);
    private ResolutionMethod resolutionMethod = ResolutionMethod.OVERRIDE;
    private Resource[] resources = new Resource[0];
    private Map<String, String> documentMatchers = new HashMap<String, String>();
    private boolean matchDefault = true;

    public void setDocumentMatchers(Map<String, String> matchers) {
        this.documentMatchers = Collections.unmodifiableMap(matchers);
    }

    public void setMatchDefault(boolean matchDefault) {
        this.matchDefault = matchDefault;
    }

    public void setResolutionMethod(ResolutionMethod resolutionMethod) {
        this.resolutionMethod = resolutionMethod;
    }

    public void setResources(Resource[] resources) {
        this.resources = resources;
    }

    protected void process(MatchCallback callback) {
        Yaml yaml = new Yaml();
        boolean found = false;
        for (Resource resource : this.resources) {
            try {
                int count = 0;
                for (Object object : yaml.loadAll(resource.getInputStream())) {
                    Map map;
                    if (this.resolutionMethod == ResolutionMethod.FIRST_FOUND && found || (map = (Map)object) == null) continue;
                    this.process(map, callback);
                    found = true;
                    ++count;
                }
                logger.debug((Object)("Loaded " + count + " document" + (count > 1 ? "s" : "") + " from YAML resource: " + resource));
                if (this.resolutionMethod != ResolutionMethod.FIRST_FOUND || !found) continue;
                break;
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException && e.getMessage().contains("${APPLICATION_CONFIG_FILE}") && (this.resolutionMethod == ResolutionMethod.FIRST_FOUND || this.resolutionMethod == ResolutionMethod.OVERRIDE_AND_IGNORE)) {
                    logger.debug((Object)("Could not load map from " + resource + ": " + e.getMessage()));
                    continue;
                }
                if (this.resolutionMethod == ResolutionMethod.FIRST_FOUND || this.resolutionMethod == ResolutionMethod.OVERRIDE_AND_IGNORE) {
                    logger.warn((Object)("Could not load map from " + resource + ": " + e.getMessage()));
                    continue;
                }
                throw new IllegalStateException(e);
            }
        }
    }

    private void process(Map<String, Object> map, MatchCallback callback) {
        Properties properties = new Properties();
        this.assignProperties(properties, map, null);
        if (this.documentMatchers.isEmpty()) {
            logger.debug((Object)("Merging document (no matchers set):\n" + UaaMapUtils.prettyPrintYaml(UaaMapUtils.redactValues(map))));
            callback.process(properties, map);
        } else {
            boolean keyFound = false;
            boolean valueFound = false;
            for (Map.Entry<String, String> entry : this.documentMatchers.entrySet()) {
                String key = entry.getKey();
                String pattern = entry.getValue();
                if (!properties.containsKey(key)) continue;
                keyFound = true;
                String value = properties.getProperty(key);
                if (!value.matches(pattern)) continue;
                logger.debug((Object)("Matched document with " + key + "=" + value + " (pattern=/" + pattern + "/):\n" + UaaMapUtils.prettyPrintYaml(UaaMapUtils.redactValues(map))));
                callback.process(properties, map);
                valueFound = true;
                break;
            }
            if (!keyFound && this.matchDefault) {
                logger.debug((Object)("Matched document with default matcher:\n" + UaaMapUtils.prettyPrintYaml(UaaMapUtils.redactValues(map))));
                callback.process(properties, map);
            } else if (!valueFound) {
                logger.debug((Object)"Unmatched document");
            }
        }
    }

    private void assignProperties(Properties properties, Map<String, Object> input, String path) {
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (StringUtils.hasText((String)path)) {
                key = key.startsWith("[") ? path + key : path + "." + key;
            }
            if ((value = entry.getValue()) instanceof String) {
                properties.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                this.assignProperties(properties, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                properties.put(key, StringUtils.collectionToCommaDelimitedString((Collection)collection));
                int count = 0;
                for (Object object : collection) {
                    this.assignProperties(properties, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            properties.put(key, value == null ? "" : value);
        }
    }

    public static enum ResolutionMethod {
        OVERRIDE,
        OVERRIDE_AND_IGNORE,
        FIRST_FOUND;

    }

    public static interface MatchCallback {
        public void process(Properties var1, Map<String, Object> var2);
    }
}

