/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.impl.config;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Optional;
import org.cloudfoundry.identity.uaa.provider.ldap.ExtendedLdapUserMapper;
import org.cloudfoundry.identity.uaa.provider.ldap.PasswordComparisonAuthenticator;
import org.cloudfoundry.identity.uaa.provider.ldap.ProcessLdapProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

@Configuration
@Conditional(value={IfConfigured.class})
public class LdapSearchAndCompareConfig {
    @Bean
    public DefaultSpringSecurityContextSource defaultSpringSecurityContextSource(Environment environment, Map ldapProperties, ProcessLdapProperties ldapPropertyProcessor) throws ClassNotFoundException, KeyManagementException, NoSuchAlgorithmException, InstantiationException, IllegalAccessException {
        String providerUrl = Optional.ofNullable(environment.getProperty("ldap.base.url")).orElse("ldap://localhost:389/dc=test,dc=com");
        DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(providerUrl);
        contextSource.setUserDn(Optional.ofNullable(environment.getProperty("ldap.base.userDn")).orElse("cn=admin,ou=Users,dc=test,dc=com"));
        contextSource.setPassword(Optional.ofNullable(environment.getProperty("ldap.base.password")).orElse("adminsecret"));
        contextSource.setBaseEnvironmentProperties(ldapProperties);
        contextSource.setPooled(false);
        contextSource.setAuthenticationStrategy(ldapPropertyProcessor.getAuthenticationStrategy());
        return contextSource;
    }

    @Bean
    public LdapAuthenticationProvider ldapAuthProvider(BaseLdapPathContextSource contextSource, Environment environment, LdapAuthoritiesPopulator ldapAuthoritiesPopulator, GrantedAuthoritiesMapper ldapAuthoritiesMapper, ExtendedLdapUserMapper extendedLdapUserDetailsMapper) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        PasswordComparisonAuthenticator authenticator = new PasswordComparisonAuthenticator(contextSource);
        String searchBase = Optional.ofNullable(environment.getProperty("ldap.base.searchBase")).orElse("dc=test,dc=com");
        String searchFilter = Optional.ofNullable(environment.getProperty("ldap.base.searchFilter")).orElse("cn={0}");
        FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(searchBase, searchFilter, contextSource);
        String passwordAttributeName = Optional.ofNullable(environment.getProperty("ldap.base.passwordAttributeName")).orElse("userPassword");
        String passwordEncoderClassName = Optional.ofNullable(environment.getProperty("ldap.base.passwordEncoder")).orElse("org.cloudfoundry.identity.uaa.provider.ldap.DynamicPasswordComparator");
        PasswordEncoder passwordEncoder = (PasswordEncoder)Class.forName(passwordEncoderClassName).newInstance();
        boolean localCompare = Optional.ofNullable(environment.getProperty("ldap.base.localPasswordCompare")).map(Boolean::parseBoolean).orElse(true);
        authenticator.setUserSearch((LdapUserSearch)userSearch);
        authenticator.setPasswordAttributeName(passwordAttributeName);
        authenticator.setPasswordEncoder(passwordEncoder);
        authenticator.setLocalCompare(localCompare);
        LdapAuthenticationProvider ldapAuthenticationProvider = new LdapAuthenticationProvider((LdapAuthenticator)authenticator, ldapAuthoritiesPopulator);
        ldapAuthenticationProvider.setAuthoritiesMapper(ldapAuthoritiesMapper);
        ldapAuthenticationProvider.setUserDetailsContextMapper((UserDetailsContextMapper)extendedLdapUserDetailsMapper);
        return ldapAuthenticationProvider;
    }

    @Bean
    public String testLdapProfile() {
        return "ldap-search-and-compare.xml";
    }

    public static class IfConfigured
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String ldapProfileFile = context.getEnvironment().getProperty("ldap.profile.file");
            return ldapProfileFile != null && ldapProfileFile.equals("ldap/ldap-search-and-compare.xml");
        }
    }
}

