/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.home;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.Assert;

public class BuildInfo
implements InitializingBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    @Value(value="${uaa.url:http://localhost:8080/uaa}")
    private String uaaUrl;
    private String version;
    private String commitId;
    private String timestamp;

    public void afterPropertiesSet() {
        try {
            Properties gitProperties = PropertiesLoaderUtils.loadAllProperties((String)"git.properties");
            this.commitId = gitProperties.getProperty("git.commit.id.abbrev", "UNKNOWN");
            String currentTime = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date());
            this.timestamp = gitProperties.getProperty("git.commit.time", currentTime);
        }
        catch (IOException e) {
            this.logger.debug((Object)"Exception loading git.properties", (Throwable)e);
        }
        try {
            Properties buildProperties = PropertiesLoaderUtils.loadAllProperties((String)"build.properties");
            this.version = buildProperties.getProperty("build.version");
        }
        catch (IOException e) {
            this.logger.debug((Object)"Exception loading build.properties", (Throwable)e);
        }
        Assert.hasText((String)this.uaaUrl);
        Assert.hasText((String)this.version);
        Assert.hasText((String)this.commitId);
        Assert.hasText((String)this.timestamp);
    }

    public String getVersion() {
        return this.version;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getUaaUrl() {
        return this.uaaUrl;
    }
}

