/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.error;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cloudfoundry.identity.uaa.error.UaaException;

public class UaaExceptionDeserializer
extends JsonDeserializer<UaaException> {
    public UaaException deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String errorMessage;
        int status = 400;
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        }
        HashMap<String, String> errorParams = new HashMap<String, String>();
        while (t == JsonToken.FIELD_NAME) {
            String value;
            String fieldName = jp.getCurrentName();
            t = jp.nextToken();
            if (t == JsonToken.VALUE_NULL) {
                value = null;
            } else {
                value = jp.getText();
                if (fieldName.equals("status")) {
                    try {
                        status = Integer.valueOf(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            errorParams.put(fieldName, value);
            t = jp.nextToken();
        }
        String errorCode = (String)errorParams.get("error");
        String string = errorMessage = errorParams.containsKey("error_description") ? (String)errorParams.get("error_description") : null;
        if (errorMessage == null) {
            errorMessage = errorCode == null ? "UAA Error" : errorCode;
        }
        UaaException ex = new UaaException(errorCode, errorMessage, status);
        Set entries = errorParams.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            if ("error".equals(key) || "error_description".equals(key) || "status".equals(key)) continue;
            ex.addAdditionalInformation(key, (String)entry.getValue());
        }
        return ex;
    }
}

