/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.db;

import java.sql.Connection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.flywaydb.core.api.migration.jdbc.JdbcMigration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;

public class FixFailedBackportMigrations_4_0_4
implements JdbcMigration {
    private static final Log logger = LogFactory.getLog(FixFailedBackportMigrations_4_0_4.class);
    private String type;
    private final Map<String, String> scripts;
    private final String checkExistsSql = "SELECT count(*) FROM schema_version WHERE version = ?";

    public FixFailedBackportMigrations_4_0_4(String type) {
        this.type = type;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("3.9.1", "V3_9_1__PasswordChangeRequired.sql");
        map.put("3.10.0", "V3_10_0__UserInfo.sql");
        map.put("3.10.1", "V3_10_1__Add_Last_Logon_To_User.sql");
        map.put("3.10.2", "V3_10_2__Add_Created_By_To_Oauth_Client_Details.sql");
        map.put("3.10.3", "V3_10_3__Add_Previous_Logon_To_User.sql");
        this.scripts = Collections.unmodifiableMap(map);
    }

    public void migrate(Connection connection) throws Exception {
        if ("sqlserver".equals(this.type) || "hsqldb".equals(this.type)) {
            logger.info((Object)("Skipping 4.0.4 migration for " + this.type + ", not affected by 3.9.9 back ports."));
            return;
        }
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        SingleConnectionDataSource dataSource = new SingleConnectionDataSource(connection, true);
        JdbcTemplate template = new JdbcTemplate((DataSource)dataSource);
        boolean run = false;
        for (Map.Entry<String, String> script : this.getScripts()) {
            int count = (Integer)template.queryForObject("SELECT count(*) FROM schema_version WHERE version = ?", Integer.class, new Object[]{script.getKey()});
            if (count != 0) continue;
            String path = "org/cloudfoundry/identity/uaa/db/" + this.type + "/" + script.getValue();
            logger.info((Object)String.format("[4.0.4] Adding script for version %s with path %s", script.getKey(), path));
            populator.addScript((Resource)new ClassPathResource(path));
            run = true;
        }
        if (run) {
            logger.info((Object)"Running missing migrations.");
            populator.setContinueOnError(false);
            populator.setIgnoreFailedDrops(true);
            populator.populate(connection);
            logger.info((Object)"Completed missing migrations.");
        } else {
            logger.info((Object)"Skipping 4.0.4 migrations, no migrations missing.");
        }
    }

    public Set<Map.Entry<String, String>> getScripts() {
        return this.scripts.entrySet();
    }
}

