/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.db;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.flywaydb.core.api.migration.spring.SpringJdbcMigration;
import org.springframework.jdbc.core.JdbcTemplate;

public class BootstrapIdentityZones
implements SpringJdbcMigration {
    public void migrate(JdbcTemplate jdbcTemplate) throws Exception {
        IdentityZone uaa = IdentityZone.getUaa();
        Timestamp t = new Timestamp(uaa.getCreated().getTime());
        jdbcTemplate.update("insert into identity_zone VALUES (?,?,?,?,?,?,?)", new Object[]{uaa.getId(), t, t, uaa.getVersion(), uaa.getSubdomain(), uaa.getName(), uaa.getDescription()});
        HashMap<String, String> originMap = new HashMap<String, String>();
        LinkedHashSet<String> origins = new LinkedHashSet<String>();
        origins.addAll(Arrays.asList("uaa", "login-server", "ldap", "keystone"));
        origins.addAll(jdbcTemplate.queryForList("SELECT DISTINCT origin from users", String.class));
        for (String origin : origins) {
            String identityProviderId = UUID.randomUUID().toString();
            originMap.put(origin, identityProviderId);
            jdbcTemplate.update("insert into identity_provider VALUES (?,?,?,0,?,?,?,?,null)", new Object[]{identityProviderId, t, t, uaa.getId(), origin, origin, origin});
        }
        jdbcTemplate.update("update oauth_client_details set identity_zone_id = ?", new Object[]{uaa.getId()});
        List clientIds = jdbcTemplate.queryForList("SELECT client_id from oauth_client_details", String.class);
        for (String clientId : clientIds) {
            jdbcTemplate.update("insert into client_idp values (?,?) ", new Object[]{clientId, originMap.get("uaa")});
        }
        jdbcTemplate.update("update users set identity_provider_id = (select id from identity_provider where identity_provider.origin_key = users.origin), identity_zone_id = (select identity_zone_id from identity_provider where identity_provider.origin_key = users.origin);");
        jdbcTemplate.update("update group_membership set identity_provider_id = (select id from identity_provider where identity_provider.origin_key = group_membership.origin);");
    }
}

