/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.cypto;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Arrays;
import org.cloudfoundry.identity.uaa.cypto.EncryptionServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionService {
    private Logger logger = LoggerFactory.getLogger(EncryptionService.class);
    private String passphrase;
    private final int GCM_AUTHENTICATION_TAG_SIZE_BITS = 128;
    private final int GCM_IV_NONCE_SIZE_BYTES = 12;
    private final int PBKDF2_ITERATIONS = 65536;
    private final int PBKDF2_SALT_SIZE_BYTES = 32;
    private final int AES_KEY_LENGTH_BITS = 256;
    private final String CIPHER = "AES";
    private final String CIPHERSCHEME = "AES/GCM/NoPadding";
    private SecureRandom random = new SecureRandom();

    public EncryptionService(String passphrase) {
        this.passphrase = passphrase;
    }

    public byte[] encrypt(String plaintext) throws EncryptionServiceException {
        try {
            byte[] newSalt = this.generateRandomArray(32);
            SecretKeySpec key = new SecretKeySpec(this.generateKey(newSalt), "AES");
            Cipher myCipher = Cipher.getInstance("AES/GCM/NoPadding");
            byte[] newNonce = this.generateRandomArray(12);
            GCMParameterSpec spec = new GCMParameterSpec(128, newNonce);
            myCipher.init(1, (Key)key, spec);
            byte[] bytes = plaintext.getBytes();
            return Arrays.concatenate((byte[])newNonce, (byte[])newSalt, (byte[])myCipher.doFinal(bytes));
        }
        catch (Exception e) {
            this.logger.error("Encryption failed", (Throwable)e);
            throw new EncryptionServiceException(e);
        }
    }

    public byte[] decrypt(byte[] encrypt) throws EncryptionServiceException {
        try {
            byte[] myNonce = new byte[12];
            byte[] mySalt = new byte[32];
            ByteArrayInputStream fileInputStream = new ByteArrayInputStream(encrypt);
            fileInputStream.read(myNonce);
            fileInputStream.read(mySalt);
            SecretKeySpec key = new SecretKeySpec(this.generateKey(mySalt), "AES");
            Cipher myCipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec spec = new GCMParameterSpec(128, myNonce);
            myCipher.init(2, (Key)key, spec);
            return myCipher.doFinal(Arrays.copyOfRange((byte[])encrypt, (int)44, (int)encrypt.length));
        }
        catch (Exception e) {
            this.logger.error("Decryption failed", (Throwable)e);
            throw new EncryptionServiceException(e);
        }
    }

    private byte[] generateRandomArray(int sizeInBytes) throws NoSuchAlgorithmException {
        byte[] randomArray = new byte[sizeInBytes];
        this.random.nextBytes(randomArray);
        return randomArray;
    }

    private byte[] generateKey(byte[] salt) throws UnsupportedEncodingException {
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator((Digest)new SHA256Digest());
        gen.init(this.passphrase.getBytes("UTF-8"), salt, 65536);
        return ((KeyParameter)gen.generateDerivedParameters(256)).getKey();
    }
}

