/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.client;

import java.util.List;
import java.util.Map;
import org.cloudfoundry.identity.uaa.client.PreAuthenticatedPrincipalSource;
import org.cloudfoundry.identity.uaa.client.SocialClientUserDetails;
import org.cloudfoundry.identity.uaa.user.UaaAuthority;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import org.springframework.web.client.RestOperations;

public class SocialClientUserDetailsSource
implements InitializingBean,
PreAuthenticatedPrincipalSource<Authentication> {
    private RestOperations restTemplate;
    private String userInfoUrl;

    public void setRestTemplate(RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setUserInfoUrl(String userInfoUrl) {
        this.userInfoUrl = userInfoUrl;
    }

    public void afterPropertiesSet() {
        Assert.state((this.userInfoUrl != null ? 1 : 0) != 0, (String)"User info URL must be provided");
        Assert.state((this.restTemplate != null ? 1 : 0) != 0, (String)"RestTemplate URL must be provided");
    }

    @Override
    public Authentication getPrincipal() {
        Map map = (Map)this.restTemplate.getForObject(this.userInfoUrl, Map.class, new Object[0]);
        String userName = this.getUserName(map);
        String email = null;
        if (map.containsKey("email")) {
            email = (String)map.get("email");
        }
        if (userName == null && email != null) {
            userName = email;
        }
        if (userName == null) {
            userName = (String)map.get("id");
        }
        List<UaaAuthority> authorities = UaaAuthority.USER_AUTHORITIES;
        SocialClientUserDetails user = new SocialClientUserDetails(userName, authorities);
        user.setSource(SocialClientUserDetails.Source.classify(this.userInfoUrl));
        user.setExternalId(this.getUserId(map));
        String fullName = this.getFullName(map);
        if (fullName != null) {
            user.setFullName(fullName);
        }
        if (email != null) {
            user.setEmail(email);
        }
        return user;
    }

    private String getFullName(Map<String, String> map) {
        if (map.containsKey("name")) {
            return map.get("name");
        }
        if (map.containsKey("formattedName")) {
            return map.get("formattedName");
        }
        if (map.containsKey("fullName")) {
            return map.get("fullName");
        }
        String firstName = null;
        if (map.containsKey("firstName")) {
            firstName = map.get("firstName");
        }
        if (map.containsKey("givenName")) {
            firstName = map.get("givenName");
        }
        String lastName = null;
        if (map.containsKey("lastName")) {
            lastName = map.get("lastName");
        }
        if (map.containsKey("familyName")) {
            lastName = map.get("familyName");
        }
        if (firstName != null && lastName != null) {
            return firstName + " " + lastName;
        }
        return null;
    }

    private Object getUserId(Map<String, String> map) {
        String key = "id";
        if (this.userInfoUrl.contains("run.pivotal.io")) {
            key = "user_id";
        }
        return map.get(key);
    }

    private String getUserName(Map<String, String> map) {
        String key = "username";
        if (map.containsKey(key)) {
            return map.get(key);
        }
        if (this.userInfoUrl.contains("run.pivotal.io") || this.userInfoUrl.endsWith("/uaa/userinfo")) {
            key = "user_name";
        }
        if (this.userInfoUrl.contains("github.com")) {
            key = "login";
        }
        if (this.userInfoUrl.contains("twitter.com")) {
            key = "screen_name";
        }
        String value = map.get(key);
        return value;
    }
}

