/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.manager.AccountLoginPolicy;
import org.cloudfoundry.identity.uaa.authentication.manager.LoginPolicy;
import org.cloudfoundry.identity.uaa.provider.LockoutPolicy;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class PeriodLockoutPolicy
implements AccountLoginPolicy {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final LoginPolicy loginPolicy;
    private final LoginPolicy mfaPolicy;

    public PeriodLockoutPolicy(LoginPolicy loginPolicy, LoginPolicy mfaPolicy) {
        this.loginPolicy = loginPolicy;
        this.mfaPolicy = mfaPolicy;
    }

    public LockoutPolicy getDefaultLockoutPolicy() {
        return this.loginPolicy.getLockoutPolicyRetriever().getDefaultLockoutPolicy();
    }

    @Override
    public boolean isAllowed(UaaUser user, Authentication a) throws AuthenticationException {
        LoginPolicy.Result loginResult = this.loginPolicy.isAllowed(user.getId());
        LoginPolicy.Result mfaResult = this.mfaPolicy.isAllowed(user.getId());
        if (loginResult.isAllowed() && mfaResult.isAllowed()) {
            return true;
        }
        this.logger.warn((Object)("User " + user.getUsername() + " and id " + user.getId() + " has " + loginResult.getFailureCount() + " failed user logins within the last checking period. and " + mfaResult.getFailureCount() + " failed  mfa attempts within the last checking period."));
        return false;
    }
}

