/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Map;
import org.cloudfoundry.identity.uaa.authentication.manager.RestAuthenticationManager;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;

public class KeystoneAuthenticationManager
extends RestAuthenticationManager {
    @Override
    protected HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        return headers;
    }

    @Override
    protected boolean evaluateResponse(Authentication authentication, ResponseEntity<Map> response) {
        boolean v2 = true;
        Map map = (Map)((Map)response.getBody()).get("access");
        if (map == null) {
            v2 = false;
            map = (Map)((Map)response.getBody()).get("token");
        }
        Map user = (Map)map.get("user");
        return authentication.getPrincipal().toString().equals(user.get(v2 ? "username" : "name"));
    }

    @Override
    protected KeystoneAuthenticationRequest getParameters(String username, String password) {
        if (this.getRemoteUrl() != null && this.getRemoteUrl().indexOf("/v2.0") > 0) {
            return new KeystoneV2AuthenticationRequest("", username, password);
        }
        if (this.getRemoteUrl() != null && this.getRemoteUrl().indexOf("/v3") > 0) {
            return new KeystoneV3AuthenticationRequest("", username, password);
        }
        throw new UnsupportedOperationException("Unable to determine API version:" + this.getRemoteUrl());
    }

    public static class KeystoneV3AuthenticationRequest
    implements KeystoneAuthenticationRequest {
        private KeystoneIdentity identity;

        public KeystoneV3AuthenticationRequest(String domain, String username, String password) {
            this.identity = new KeystoneIdentity(new KeystoneAuthentication(domain, username, password));
        }

        @JsonProperty(value="auth")
        public KeystoneIdentity getIdentity() {
            return this.identity;
        }

        public static class KeystoneDomain {
            public String getName() {
                return "Default";
            }
        }

        public static class KeystoneUser {
            private String name;
            private String password;

            public KeystoneUser(String name, String password) {
                this.name = name;
                this.password = password;
            }

            public KeystoneDomain getDomain() {
                return new KeystoneDomain();
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getPassword() {
                return this.password;
            }

            public void setPassword(String password) {
                this.password = password;
            }
        }

        public static class KeystoneCredentials {
            private KeystoneUser user;

            public KeystoneCredentials(String username, String password) {
                this.user = new KeystoneUser(username, password);
            }

            public KeystoneUser getUser() {
                return this.user;
            }

            public void setUser(KeystoneUser user) {
                this.user = user;
            }
        }

        public static class KeystoneAuthentication {
            private String[] methods = new String[]{"password"};
            private String domain;
            private KeystoneCredentials credentials;

            public KeystoneAuthentication(String domain, String username, String password) {
                this.domain = domain;
                this.credentials = new KeystoneCredentials(username, password);
            }

            @JsonProperty(value="methods")
            public String[] getMethods() {
                return this.methods;
            }

            @JsonProperty(value="methods")
            public void setMethods(String[] methods) {
                this.methods = methods;
            }

            @JsonProperty(value="password")
            public KeystoneCredentials getCredentials() {
                return this.credentials;
            }

            @JsonProperty(value="password")
            public void setCredentials(KeystoneCredentials credentials) {
                this.credentials = credentials;
            }
        }

        public static class KeystoneIdentity {
            private KeystoneAuthentication auth;

            public KeystoneIdentity(KeystoneAuthentication auth) {
                this.auth = auth;
            }

            @JsonProperty(value="identity")
            public KeystoneAuthentication getAuth() {
                return this.auth;
            }

            @JsonProperty(value="identity")
            public void setAuth(KeystoneAuthentication auth) {
                this.auth = auth;
            }
        }
    }

    public static class KeystoneV2AuthenticationRequest
    implements KeystoneAuthenticationRequest {
        private KeystoneAuthentication auth;

        public KeystoneV2AuthenticationRequest(String tenant, String username, String password) {
            this.auth = new KeystoneAuthentication(tenant, username, password);
        }

        public KeystoneV2AuthenticationRequest(KeystoneAuthentication auth) {
            this.auth = auth;
        }

        @JsonProperty(value="auth")
        public KeystoneAuthentication getAuth() {
            return this.auth;
        }

        @JsonProperty(value="auth")
        public void setAuth(KeystoneAuthentication auth) {
            this.auth = auth;
        }

        public static class KeystoneCredentials {
            private String username;
            private String password;

            public KeystoneCredentials(String username, String password) {
                this.username = username;
                this.password = password;
            }

            public String getUsername() {
                return this.username;
            }

            public void setUsername(String username) {
                this.username = username;
            }

            public String getPassword() {
                return this.password;
            }

            public void setPassword(String password) {
                this.password = password;
            }
        }

        public static class KeystoneAuthentication {
            private String tenant;
            private KeystoneCredentials credentials;

            public KeystoneAuthentication(String tenant, String username, String password) {
                this.tenant = tenant;
                this.credentials = new KeystoneCredentials(username, password);
            }

            @JsonProperty(value="tenantName")
            public String getTenant() {
                return this.tenant;
            }

            @JsonProperty(value="tenantName")
            public void setTenant(String tenant) {
                this.tenant = tenant;
            }

            @JsonProperty(value="passwordCredentials")
            public KeystoneCredentials getCredentials() {
                return this.credentials;
            }

            public void setCredentials(KeystoneCredentials credentials) {
                this.credentials = credentials;
            }
        }
    }

    public static interface KeystoneAuthenticationRequest {
    }
}

