/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import java.nio.file.ProviderNotFoundException;
import org.cloudfoundry.identity.uaa.authentication.event.IdentityProviderAuthenticationFailureEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.ChainedAuthenticationManager;
import org.cloudfoundry.identity.uaa.authentication.manager.LdapLoginAuthenticationManager;
import org.cloudfoundry.identity.uaa.impl.config.EnvironmentPropertiesFactoryBean;
import org.cloudfoundry.identity.uaa.provider.LdapIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.util.LdapUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class DynamicLdapAuthenticationManager
implements AuthenticationManager {
    private final LdapIdentityProviderDefinition definition;
    private ClassPathXmlApplicationContext context = null;
    private ScimGroupExternalMembershipManager scimGroupExternalMembershipManager;
    private ScimGroupProvisioning scimGroupProvisioning;
    private LdapLoginAuthenticationManager ldapLoginAuthenticationManager;
    private AuthenticationManager manager;
    private AuthenticationManager ldapManagerActual;
    private ApplicationEventPublisher eventPublisher;

    public DynamicLdapAuthenticationManager(LdapIdentityProviderDefinition definition, ScimGroupExternalMembershipManager scimGroupExternalMembershipManager, ScimGroupProvisioning scimGroupProvisioning, LdapLoginAuthenticationManager ldapLoginAuthenticationManager) {
        this.definition = definition;
        this.scimGroupExternalMembershipManager = scimGroupExternalMembershipManager;
        this.scimGroupProvisioning = scimGroupProvisioning;
        this.ldapLoginAuthenticationManager = ldapLoginAuthenticationManager;
    }

    public ClassPathXmlApplicationContext getContext() {
        return this.context;
    }

    public synchronized AuthenticationManager getLdapAuthenticationManager() throws BeansException {
        if (this.definition == null) {
            return null;
        }
        if (this.manager != null) {
            return this.manager;
        }
        if (this.context == null) {
            ConfigurableEnvironment environment = LdapUtils.getLdapConfigurationEnvironment(this.definition);
            DefaultListableBeanFactory parentBeanFactory = new DefaultListableBeanFactory();
            parentBeanFactory.registerSingleton("externalGroupMembershipManager", (Object)this.scimGroupExternalMembershipManager);
            parentBeanFactory.registerSingleton("scimGroupProvisioning", (Object)this.scimGroupProvisioning);
            parentBeanFactory.registerSingleton("ldapLoginAuthenticationMgr", (Object)this.ldapLoginAuthenticationManager);
            GenericApplicationContext parent = new GenericApplicationContext(parentBeanFactory);
            parent.refresh();
            this.context = new ClassPathXmlApplicationContext(new String[]{"ldap-integration.xml"}, false, (ApplicationContext)parent);
            this.context.setEnvironment(environment);
            EnvironmentPropertiesFactoryBean factoryBean = new EnvironmentPropertiesFactoryBean();
            factoryBean.setEnvironment((Environment)environment);
            PropertySourcesPlaceholderConfigurer placeholderConfigurer = new PropertySourcesPlaceholderConfigurer();
            placeholderConfigurer.setProperties(factoryBean.getObject());
            placeholderConfigurer.setLocalOverride(true);
            this.context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)placeholderConfigurer);
            this.context.refresh();
            this.ldapManagerActual = (AuthenticationManager)this.context.getBean("ldapAuthenticationManager");
            AuthenticationManager shadowUserManager = (AuthenticationManager)this.context.getBean("ldapLoginAuthenticationMgr");
            ChainedAuthenticationManager chainedAuthenticationManager = new ChainedAuthenticationManager();
            ChainedAuthenticationManager.AuthenticationManagerConfiguration config1 = new ChainedAuthenticationManager.AuthenticationManagerConfiguration(this.ldapManagerActual, null);
            ChainedAuthenticationManager.AuthenticationManagerConfiguration config2 = new ChainedAuthenticationManager.AuthenticationManagerConfiguration(shadowUserManager, "ifPreviousTrue");
            chainedAuthenticationManager.setDelegates(new ChainedAuthenticationManager.AuthenticationManagerConfiguration[]{config1, config2});
            this.manager = chainedAuthenticationManager;
        }
        return this.manager;
    }

    public AuthenticationManager getLdapManagerActual() {
        return this.ldapManagerActual;
    }

    public LdapIdentityProviderDefinition getDefinition() {
        return this.definition;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        AuthenticationManager manager = this.getLdapAuthenticationManager();
        if (manager != null) {
            try {
                return manager.authenticate(authentication);
            }
            catch (BadCredentialsException e) {
                this.publish(new IdentityProviderAuthenticationFailureEvent(authentication, authentication.getName(), "ldap"));
                throw e;
            }
        }
        throw new ProviderNotFoundException("LDAP provider not configured");
    }

    public void destroy() {
        ClassPathXmlApplicationContext applicationContext = this.context;
        if (applicationContext != null) {
            this.context = null;
            applicationContext.destroy();
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    protected void publish(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }
}

