/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.event;

import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.authentication.event.AbstractUaaAuthenticationEvent;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class IdentityProviderAuthenticationSuccessEvent
extends AbstractUaaAuthenticationEvent {
    private final UaaUser user;
    private final String authenticationType;

    public IdentityProviderAuthenticationSuccessEvent(UaaUser user, Authentication authentication, String authenticationType) {
        super(authentication);
        this.user = user;
        this.authenticationType = authenticationType;
    }

    @Override
    public AuditEvent getAuditEvent() {
        Assert.notNull((Object)this.user, (String)"UaaUser cannot be null");
        return this.createAuditRecord(this.user.getId(), AuditEventType.IdentityProviderAuthenticationSuccess, this.getOrigin(this.getAuthenticationDetails()), this.user.getUsername(), this.authenticationType, null);
    }

    public UaaUser getUser() {
        return this.user;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }
}

