/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.io.IOException;
import java.util.Date;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.web.filter.OncePerRequestFilter;

public class SessionResetFilter
extends OncePerRequestFilter {
    private static Log logger = LogFactory.getLog(SessionResetFilter.class);
    private final RedirectStrategy strategy;
    private final String redirectUrl;
    private final UaaUserDatabase userDatabase;

    public SessionResetFilter(RedirectStrategy strategy, String redirectUrl, UaaUserDatabase userDatabase) {
        this.strategy = strategy;
        this.redirectUrl = redirectUrl;
        this.userDatabase = userDatabase;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        UaaAuthentication authentication;
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null && context.getAuthentication() != null && context.getAuthentication() instanceof UaaAuthentication && (authentication = (UaaAuthentication)context.getAuthentication()).isAuthenticated() && "uaa".equals(authentication.getPrincipal().getOrigin()) && null != request.getSession(false)) {
            boolean redirect = false;
            String userId = authentication.getPrincipal().getId();
            try {
                long passwordModTime;
                long lastAuthTime;
                logger.debug((Object)("Evaluating user-id for session reset:" + userId));
                UaaUser user = this.userDatabase.retrieveUserById(userId);
                Date lastModified = user.getPasswordLastModified();
                if (lastModified != null && this.hasPasswordChangedAfterAuthentication(lastAuthTime = authentication.getAuthenticatedTime(), passwordModTime = lastModified.getTime())) {
                    logger.debug((Object)String.format("Resetting user session for user ID: %s Auth Time: %s Password Change Time: %s", userId, lastAuthTime, passwordModTime));
                    redirect = true;
                }
            }
            catch (UsernameNotFoundException x) {
                logger.info((Object)("Authenticated user [" + userId + "] was not found in DB."));
                redirect = true;
            }
            if (redirect) {
                this.handleRedirect(request, response);
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean hasPasswordChangedAfterAuthentication(long lastAuthTime, long passwordModTime) {
        return passwordModTime > lastAuthTime;
    }

    protected void handleRedirect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        this.strategy.sendRedirect(request, response, this.getRedirectUrl());
    }
}

