/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.authentication.PasswordChangeRequiredException;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.filter.OncePerRequestFilter;

public class PasswordChangeRequiredFilter
extends OncePerRequestFilter {
    private final AuthenticationEntryPoint entryPoint;

    public PasswordChangeRequiredFilter(AuthenticationEntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.needsPasswordReset()) {
            this.entryPoint.commence(request, response, (AuthenticationException)new PasswordChangeRequiredException((UaaAuthentication)SecurityContextHolder.getContext().getAuthentication(), "password reset is required"));
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected boolean needsPasswordReset() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && authentication instanceof UaaAuthentication && ((UaaAuthentication)authentication).isRequiresPasswordChange() && authentication.isAuthenticated();
    }
}

