/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.BackwardsCompatibleTokenEndpointAuthenticationFilter;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.login.PasscodeInformation;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.util.StringUtils;

public class PasscodeAuthenticationFilter
extends BackwardsCompatibleTokenEndpointAuthenticationFilter {
    private final Log logger = LogFactory.getLog(this.getClass());
    private List<String> parameterNames = Collections.emptyList();

    public PasscodeAuthenticationFilter(UaaUserDatabase uaaUserDatabase, AuthenticationManager authenticationManager, OAuth2RequestFactory oAuth2RequestFactory, ExpiringCodeStore expiringCodeStore) {
        super(new ExpiringCodeAuthenticationManager(uaaUserDatabase, authenticationManager, LogFactory.getLog(PasscodeAuthenticationFilter.class), expiringCodeStore, Collections.singleton(HttpMethod.POST.toString())), oAuth2RequestFactory);
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        PasscodeHttpServletRequest request = new PasscodeHttpServletRequest((HttpServletRequest)req);
        super.doFilter((ServletRequest)request, res, chain);
    }

    @Override
    protected Authentication extractCredentials(HttpServletRequest request) {
        String grantType = request.getParameter("grant_type");
        if (grantType != null && grantType.equals("password")) {
            Map<String, String> credentials = this.getCredentials(request);
            String passcode = credentials.get("passcode");
            if (passcode != null) {
                return new ExpiringCodeAuthentication(request, passcode);
            }
            return super.extractCredentials(request);
        }
        return null;
    }

    private Map<String, String> getCredentials(HttpServletRequest request) {
        HashMap<String, String> credentials = new HashMap<String, String>();
        for (String paramName : this.parameterNames) {
            String value = request.getParameter(paramName);
            if (value == null) continue;
            if (value.startsWith("{")) {
                try {
                    Map jsonCredentials = (Map)JsonUtils.readValue((String)value, (TypeReference)new TypeReference<Map<String, String>>(){});
                    credentials.putAll(jsonCredentials);
                }
                catch (JsonUtils.JsonUtilException e) {
                    this.logger.warn((Object)("Unknown format of value for request param: " + paramName + ". Ignoring."));
                }
                continue;
            }
            credentials.put(paramName, value);
        }
        return credentials;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void destroy() {
    }

    public void setParameterNames(List<String> parameterNames) {
        this.parameterNames = parameterNames;
    }

    protected static class ExpiringCodeAuthenticationManager
    implements AuthenticationManager {
        private final Log logger;
        private final ExpiringCodeStore expiringCodeStore;
        private final Set<String> methods;
        private final AuthenticationManager parent;
        private final UaaUserDatabase uaaUserDatabase;

        public ExpiringCodeAuthenticationManager(UaaUserDatabase uaaUserDatabase, AuthenticationManager parent, Log logger, ExpiringCodeStore expiringCodeStore, Set<String> methods) {
            this.logger = logger;
            this.expiringCodeStore = expiringCodeStore;
            this.methods = methods;
            this.parent = parent;
            this.uaaUserDatabase = uaaUserDatabase;
        }

        protected ExpiringCode doRetrieveCode(String code) {
            return this.expiringCodeStore.retrieveCode(code, IdentityZoneHolder.get().getId());
        }

        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            List<? extends GrantedAuthority> authorities;
            if (!(authentication instanceof ExpiringCodeAuthentication)) {
                return this.parent.authenticate(authentication);
            }
            ExpiringCodeAuthentication expiringCodeAuthentication = (ExpiringCodeAuthentication)authentication;
            this.logger.debug((Object)"Located credentials in request, with passcode");
            if (this.methods != null && !this.methods.contains(expiringCodeAuthentication.getRequest().getMethod().toUpperCase())) {
                throw new BadCredentialsException("Credentials must be sent by (one of methods): " + this.methods);
            }
            String passcode = expiringCodeAuthentication.getPasscode();
            if (StringUtils.isEmpty((Object)passcode)) {
                throw new InsufficientAuthenticationException("Passcode information is missing.");
            }
            ExpiringCode eCode = this.doRetrieveCode(passcode);
            PasscodeInformation pi = null;
            if (eCode != null && eCode.getData() != null) {
                try {
                    pi = (PasscodeInformation)JsonUtils.readValue((String)eCode.getData(), PasscodeInformation.class);
                }
                catch (JsonUtils.JsonUtilException e) {
                    throw new InsufficientAuthenticationException("Unable to deserialize passcode object.", (Throwable)e);
                }
            }
            if (pi == null) {
                throw new InsufficientAuthenticationException("Invalid passcode");
            }
            this.logger.debug((Object)("Successful passcode authentication request for " + pi.getUsername()));
            Collection externalAuthorities = null;
            if (null != pi.getAuthorizationParameters()) {
                externalAuthorities = (Collection)pi.getAuthorizationParameters().get("authorities");
            }
            UaaPrincipal principal = new UaaPrincipal(pi.getUserId(), pi.getUsername(), null, pi.getOrigin(), null, IdentityZoneHolder.get().getId());
            try {
                UaaUser user = this.uaaUserDatabase.retrieveUserById(pi.getUserId());
                authorities = user.getAuthorities();
            }
            catch (UsernameNotFoundException x) {
                throw new BadCredentialsException("Invalid user.");
            }
            UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken((Object)principal, null, externalAuthorities == null || externalAuthorities.size() == 0 ? authorities : externalAuthorities);
            PasscodeHttpServletRequest pcRequest = (PasscodeHttpServletRequest)expiringCodeAuthentication.getRequest();
            pcRequest.addParameter("username", new String[]{pi.getUsername()});
            pcRequest.addParameter("origin", new String[]{pi.getOrigin()});
            return result;
        }
    }

    protected static class PasscodeHttpServletRequest
    extends HttpServletRequestWrapper {
        Map<String, String[]> extendedParameters = new HashMap<String, String[]>();

        public PasscodeHttpServletRequest(HttpServletRequest request) {
            super(request);
        }

        public void addParameter(String name, String[] values) {
            this.extendedParameters.put(name, values);
        }

        public Map<String, String[]> getParameterMap() {
            HashMap<String, String[]> result = new HashMap<String, String[]>(this.extendedParameters);
            result.putAll(super.getParameterMap());
            return result;
        }
    }

    protected static class ExpiringCodeAuthentication
    implements Authentication {
        private final HttpServletRequest request;
        private final String passcode;

        public ExpiringCodeAuthentication(HttpServletRequest request, String passcode) {
            this.request = request;
            this.passcode = passcode;
        }

        public Collection<? extends GrantedAuthority> getAuthorities() {
            return null;
        }

        public Object getCredentials() {
            return null;
        }

        public Object getDetails() {
            return null;
        }

        public Object getPrincipal() {
            return null;
        }

        public boolean isAuthenticated() {
            return false;
        }

        public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public String getPasscode() {
            return this.passcode;
        }

        public String getName() {
            return this.getPasscode();
        }
    }
}

