/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.authentication.AuthzAuthenticationRequest;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.endpoint.TokenEndpointAuthenticationFilter;
import org.springframework.util.StringUtils;

public class LoginServerTokenEndpointFilter
extends TokenEndpointAuthenticationFilter {
    private List<String> parameterNames = Collections.emptyList();

    public LoginServerTokenEndpointFilter(AuthenticationManager authenticationManager, OAuth2RequestFactory oAuth2RequestFactory, List<String> addNewUserParameters) {
        super(authenticationManager, oAuth2RequestFactory);
        this.parameterNames = addNewUserParameters;
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        super.onSuccessfulAuthentication(request, response, authResult);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth instanceof OAuth2Authentication) {
            ((OAuth2Authentication)auth).setAuthenticated(true);
        }
    }

    protected Authentication extractCredentials(HttpServletRequest request) {
        String grantType = request.getParameter("grant_type");
        if (grantType != null && grantType.equals("password")) {
            HashMap<String, String> loginInfo = new HashMap<String, String>();
            for (String p : this.parameterNames) {
                String value = request.getParameter(p);
                if (!StringUtils.hasText((String)value)) continue;
                loginInfo.put(p, value);
            }
            AuthzAuthenticationRequest result = new AuthzAuthenticationRequest(loginInfo, new UaaAuthenticationDetails(request));
            return result;
        }
        return null;
    }
}

