/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.error.UaaException;
import org.cloudfoundry.identity.uaa.login.CurrentUserCookieFactory;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class CurrentUserCookieRequestFilter
extends OncePerRequestFilter {
    public static final String CURRENT_USER_COOKIE_ERROR = "current_user_cookie_error";
    private Logger logger = LoggerFactory.getLogger(CurrentUserCookieRequestFilter.class);
    private CurrentUserCookieFactory currentUserCookieFactory;

    public CurrentUserCookieRequestFilter(CurrentUserCookieFactory currentUserCookieFactory) {
        this.currentUserCookieFactory = currentUserCookieFactory;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.isAuthenticated()) {
            UaaPrincipal principal = (UaaPrincipal)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            try {
                Cookie currentUserCookie = this.currentUserCookieFactory.getCookie(principal);
                response.addCookie(currentUserCookie);
            }
            catch (CurrentUserCookieFactory.CurrentUserCookieEncodingException e) {
                this.logger.error(this.errorMessage(principal), (Throwable)e);
                this.handleError(response, principal);
                return;
            }
        } else {
            Cookie currentUserCookie = this.currentUserCookieFactory.getNullCookie();
            response.addCookie(currentUserCookie);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String errorMessage(UaaPrincipal principal) {
        return String.format("There was a problem while creating the Current-User cookie for user id %s", principal.getId());
    }

    private void handleError(HttpServletResponse response, UaaPrincipal principal) throws IOException {
        int status = HttpStatus.INTERNAL_SERVER_ERROR.value();
        UaaException error = new UaaException(CURRENT_USER_COOKIE_ERROR, this.errorMessage(principal), status);
        response.setStatus(status);
        response.getWriter().write(JsonUtils.writeValueAsString((Object)error));
        response.setHeader("Content-Type", "application/json");
    }

    private boolean isAuthenticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && authentication instanceof UaaAuthentication && ((UaaAuthentication)authentication).isAuthenticated();
    }
}

