/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.user.ExtendedUaaAuthority;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AuthzAuthenticationRequest
implements Authentication {
    private final UaaAuthenticationDetails details;
    private final Map<String, String> info;

    public AuthzAuthenticationRequest(Map<String, String> info, UaaAuthenticationDetails details) {
        this.info = Collections.unmodifiableMap(info);
        Assert.notNull((Object)details);
        this.details = details;
    }

    public AuthzAuthenticationRequest(String username, String password, UaaAuthenticationDetails details) {
        Assert.hasText((String)username, (String)"username cannot be empty");
        Assert.hasText((String)password, (String)"password cannot be empty");
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("username", username.trim());
        info.put("password", password.trim());
        this.info = Collections.unmodifiableMap(info);
        this.details = details;
    }

    public Map<String, String> getInfo() {
        return this.info;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        if (null != this.info.get("authorities")) {
            String[] authorities;
            LinkedHashSet<ExtendedUaaAuthority> returnAuthorities = new LinkedHashSet<ExtendedUaaAuthority>();
            for (String authority : authorities = StringUtils.commaDelimitedListToStringArray((String)this.info.get("authorities"))) {
                returnAuthorities.add(new ExtendedUaaAuthority(authority, null));
            }
            return returnAuthorities;
        }
        return Collections.emptySet();
    }

    public String getPrincipal() {
        return this.info.get("username");
    }

    public String getCredentials() {
        return this.info.get("password");
    }

    public Object getDetails() {
        return this.details;
    }

    public boolean isAuthenticated() {
        return false;
    }

    public void setAuthenticated(boolean isAuthenticated) {
        if (isAuthenticated) {
            throw new IllegalArgumentException("Authentication request can not be 'authenticated'");
        }
    }

    public String getName() {
        return this.getPrincipal();
    }
}

