/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.audit;

import java.sql.Timestamp;
import java.util.concurrent.atomic.AtomicLong;
import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.audit.JdbcAuditService;
import org.cloudfoundry.identity.uaa.util.TimeService;
import org.cloudfoundry.identity.uaa.util.TimeServiceImpl;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcUnsuccessfulLoginCountingAuditService
extends JdbcAuditService {
    private int saveDataPeriodMillis = 86400000;
    private long timeBetweenDeleteMillis = 30000L;
    private AtomicLong lastDelete = new AtomicLong(0L);
    private TimeService timeService = new TimeServiceImpl();

    public JdbcUnsuccessfulLoginCountingAuditService(JdbcTemplate template) {
        super(template);
    }

    public void setSaveDataPeriodMillis(int saveDataPeriodMillis) {
        this.saveDataPeriodMillis = saveDataPeriodMillis;
    }

    public void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }

    @Override
    public void log(AuditEvent auditEvent, String zoneId) {
        switch (auditEvent.getType()) {
            case MfaAuthenticationSuccess: {
                this.resetAuthenticationEvents(auditEvent, zoneId, AuditEventType.MfaAuthenticationFailure);
                break;
            }
            case UserAuthenticationSuccess: 
            case PasswordChangeSuccess: {
                this.resetAuthenticationEvents(auditEvent, zoneId, AuditEventType.UserAuthenticationFailure);
                break;
            }
            case UserAccountUnlockedEvent: {
                this.resetAuthenticationEvents(auditEvent, zoneId, AuditEventType.UserAuthenticationFailure);
                this.resetAuthenticationEvents(auditEvent, zoneId, AuditEventType.MfaAuthenticationFailure);
                break;
            }
            case UserAuthenticationFailure: 
            case MfaAuthenticationFailure: {
                this.periodicDelete();
                super.log(auditEvent, zoneId);
                break;
            }
        }
    }

    private void resetAuthenticationEvents(AuditEvent auditEvent, String zoneId, AuditEventType eventType) {
        this.getJdbcTemplate().update("delete from sec_audit where principal_id=? and identity_zone_id=? and event_type=?", new Object[]{auditEvent.getPrincipalId(), zoneId, eventType.getCode()});
    }

    protected void periodicDelete() {
        long lastCheck;
        long now = this.timeService.getCurrentTimeMillis();
        if (now - (lastCheck = this.lastDelete.get()) > this.timeBetweenDeleteMillis && this.lastDelete.compareAndSet(lastCheck, now)) {
            this.getJdbcTemplate().update("delete from sec_audit where created < ?", new Object[]{new Timestamp(System.currentTimeMillis() - (long)this.saveDataPeriodMillis)});
        }
    }
}

