/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.account;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.approval.Approval;
import org.cloudfoundry.identity.uaa.approval.ApprovalStore;
import org.cloudfoundry.identity.uaa.approval.DescribedApproval;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.security.DefaultSecurityContextAccessor;
import org.cloudfoundry.identity.uaa.security.SecurityContextAccessor;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ProfileController {
    protected static Log logger = LogFactory.getLog(ProfileController.class);
    private final ApprovalStore approvalsService;
    private final ClientServicesExtension clientDetailsService;
    private final SecurityContextAccessor securityContextAccessor;

    public ProfileController(ApprovalStore approvalsService, ClientServicesExtension clientDetailsService) {
        this(approvalsService, clientDetailsService, new DefaultSecurityContextAccessor());
    }

    public ProfileController(ApprovalStore approvalsService, ClientServicesExtension clientDetailsService, SecurityContextAccessor securityContextAccessor) {
        this.approvalsService = approvalsService;
        this.clientDetailsService = clientDetailsService;
        this.securityContextAccessor = securityContextAccessor;
    }

    @RequestMapping(value={"/profile"}, method={RequestMethod.GET})
    public String get(Authentication authentication, Model model) {
        Map<String, List<DescribedApproval>> approvals = this.getCurrentApprovalsForUser(this.getCurrentUserId());
        Map<String, String> clientNames = this.getClientNames(approvals);
        model.addAttribute("clientnames", clientNames);
        model.addAttribute("approvals", approvals);
        model.addAttribute("isUaaManagedUser", (Object)this.isUaaManagedUser(authentication));
        return "approvals";
    }

    protected Map<String, String> getClientNames(Map<String, List<DescribedApproval>> approvals) {
        LinkedHashMap<String, String> clientNames = new LinkedHashMap<String, String>();
        for (String clientId : approvals.keySet()) {
            ClientDetails details = this.clientDetailsService.loadClientByClientId(clientId, IdentityZoneHolder.get().getId());
            String name = details.getClientId();
            if (details.getAdditionalInformation() != null && details.getAdditionalInformation().get("name") != null) {
                name = (String)details.getAdditionalInformation().get("name");
            }
            clientNames.put(clientId, name);
        }
        return clientNames;
    }

    @RequestMapping(value={"/profile"}, method={RequestMethod.POST})
    public String post(@RequestParam(required=false) Collection<String> checkedScopes, @RequestParam(required=false) String update, @RequestParam(required=false) String delete, @RequestParam(required=false) String clientId) {
        String userId = this.getCurrentUserId();
        if (null != update) {
            Map<String, List<DescribedApproval>> approvalsByClientId = this.getCurrentApprovalsForUser(userId);
            ArrayList<DescribedApproval> allApprovals = new ArrayList<DescribedApproval>();
            for (List<DescribedApproval> list : approvalsByClientId.values()) {
                allApprovals.addAll(list);
            }
            if (StringUtils.hasText((String)clientId)) {
                allApprovals.removeIf(da -> !clientId.equals(da.getClientId()));
            }
            for (Approval approval : allApprovals) {
                String namespacedScope = approval.getClientId() + "-" + approval.getScope();
                if (checkedScopes != null && checkedScopes.contains(namespacedScope)) {
                    approval.setStatus(Approval.ApprovalStatus.APPROVED);
                    continue;
                }
                approval.setStatus(Approval.ApprovalStatus.DENIED);
            }
            this.updateApprovals(allApprovals);
        } else if (null != delete) {
            this.deleteApprovalsForClient(userId, clientId);
        }
        return "redirect:profile";
    }

    @ExceptionHandler
    public View handleException(NoSuchClientException nsce) {
        logger.debug((Object)("Unable to find client for approvals:" + nsce.getMessage()));
        return new RedirectView("profile?error_message_code=request.invalid_parameter", true);
    }

    private boolean isUaaManagedUser(Authentication authentication) {
        if (authentication.getPrincipal() instanceof UaaPrincipal) {
            UaaPrincipal principal = (UaaPrincipal)authentication.getPrincipal();
            return "uaa".equals(principal.getOrigin());
        }
        return false;
    }

    public Map<String, List<DescribedApproval>> getCurrentApprovalsForUser(String userId) {
        HashMap<String, List<DescribedApproval>> result = new HashMap<String, List<DescribedApproval>>();
        List<Approval> approvalsResponse = this.approvalsService.getApprovalsForUser(userId, IdentityZoneHolder.get().getId());
        ArrayList<DescribedApproval> approvals = new ArrayList<DescribedApproval>();
        for (Approval approval : approvalsResponse) {
            DescribedApproval describedApproval = new DescribedApproval(approval);
            approvals.add(describedApproval);
        }
        for (DescribedApproval describedApproval : approvals) {
            String scope;
            ArrayList<DescribedApproval> clientApprovals = (ArrayList<DescribedApproval>)result.get(describedApproval.getClientId());
            if (clientApprovals == null) {
                clientApprovals = new ArrayList<DescribedApproval>();
                result.put(describedApproval.getClientId(), clientApprovals);
            }
            if (!(scope = describedApproval.getScope()).contains(".")) {
                describedApproval.setDescription("Access your data with scope '" + scope + "'");
                clientApprovals.add(describedApproval);
                continue;
            }
            String resource = scope.substring(0, scope.lastIndexOf("."));
            String access = scope.substring(scope.lastIndexOf(".") + 1);
            describedApproval.setDescription("Access your '" + resource + "' resources with scope '" + access + "'");
            clientApprovals.add(describedApproval);
        }
        for (List list : result.values()) {
            Collections.sort(list, new Comparator<DescribedApproval>(){

                @Override
                public int compare(DescribedApproval o1, DescribedApproval o2) {
                    return o1.getScope().compareTo(o2.getScope());
                }
            });
        }
        return result;
    }

    public void updateApprovals(List<DescribedApproval> approvals) {
        String zoneId = IdentityZoneHolder.get().getId();
        for (DescribedApproval approval : approvals) {
            this.approvalsService.revokeApprovalsForClientAndUser(approval.getClientId(), approval.getUserId(), zoneId);
        }
        for (DescribedApproval approval : approvals) {
            this.approvalsService.addApproval(approval, zoneId);
        }
    }

    public void deleteApprovalsForClient(String userId, String clientId) {
        this.clientDetailsService.loadClientByClientId(clientId);
        this.approvalsService.revokeApprovalsForClientAndUser(clientId, userId, IdentityZoneHolder.get().getId());
    }

    private String getCurrentUserId() {
        if (!this.securityContextAccessor.isUser()) {
            throw new AccessDeniedException("Approvals can only be managed by a user");
        }
        return this.securityContextAccessor.getUserId();
    }
}

