/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.account;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.cloudfoundry.identity.uaa.account.ConflictException;
import org.cloudfoundry.identity.uaa.account.ForgotPasswordInfo;
import org.cloudfoundry.identity.uaa.account.LostPasswordChangeRequest;
import org.cloudfoundry.identity.uaa.account.LostPasswordChangeResponse;
import org.cloudfoundry.identity.uaa.account.NotFoundException;
import org.cloudfoundry.identity.uaa.account.PasswordResetResponse;
import org.cloudfoundry.identity.uaa.account.ResetPasswordService;
import org.cloudfoundry.identity.uaa.authentication.InvalidCodeException;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeType;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.web.ConvertingExceptionView;
import org.cloudfoundry.identity.uaa.web.ExceptionReport;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.View;

@Controller
public class PasswordResetEndpoint {
    private final ResetPasswordService resetPasswordService;
    private HttpMessageConverter<?>[] messageConverters = new RestTemplate().getMessageConverters().toArray(new HttpMessageConverter[0]);
    private ExpiringCodeStore codeStore;

    public PasswordResetEndpoint(ResetPasswordService resetPasswordService) {
        this.resetPasswordService = resetPasswordService;
    }

    public void setMessageConverters(HttpMessageConverter<?>[] messageConverters) {
        this.messageConverters = messageConverters;
    }

    @RequestMapping(value={"/password_resets"}, method={RequestMethod.POST})
    public ResponseEntity<PasswordResetResponse> resetPassword(@RequestBody String email, @RequestParam(required=false, value="client_id") String clientId, @RequestParam(required=false, value="redirect_uri") String redirectUri) throws IOException {
        Authentication authentication;
        if (clientId == null && (authentication = SecurityContextHolder.getContext().getAuthentication()) instanceof OAuth2Authentication) {
            OAuth2Authentication oAuth2Authentication = (OAuth2Authentication)authentication;
            clientId = oAuth2Authentication.getOAuth2Request().getClientId();
        }
        PasswordResetResponse response = new PasswordResetResponse();
        try {
            ForgotPasswordInfo forgotPasswordInfo = this.resetPasswordService.forgotPassword(email, clientId, redirectUri);
            response.setChangeCode(forgotPasswordInfo.getResetPasswordCode().getCode());
            response.setUserId(forgotPasswordInfo.getUserId());
            return new ResponseEntity((Object)response, HttpStatus.CREATED);
        }
        catch (ConflictException e) {
            response.setUserId(e.getUserId());
            return new ResponseEntity((Object)response, HttpStatus.CONFLICT);
        }
        catch (NotFoundException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    private ExpiringCode getExpiringCode(String code) {
        ExpiringCode expiringCode = this.codeStore.retrieveCode(code, IdentityZoneHolder.get().getId());
        if (expiringCode == null) {
            throw new InvalidCodeException("invalid_code", "Sorry, your reset password link is no longer valid. Please request a new one", 422);
        }
        return expiringCode;
    }

    @RequestMapping(value={"/password_change"}, method={RequestMethod.POST})
    public ResponseEntity<LostPasswordChangeResponse> changePassword(@RequestBody LostPasswordChangeRequest passwordChangeRequest) {
        if (passwordChangeRequest.getChangeCode() != null) {
            try {
                ExpiringCode expiringCode = this.getExpiringCode(passwordChangeRequest.getChangeCode());
                ResetPasswordService.ResetPasswordResponse reset = this.resetPasswordService.resetPassword(expiringCode, passwordChangeRequest.getNewPassword());
                ScimUser user = reset.getUser();
                ExpiringCode loginCode = this.getCode(user.getId(), user.getUserName(), reset.getClientId());
                LostPasswordChangeResponse response = new LostPasswordChangeResponse();
                response.setUserId(user.getId());
                response.setUsername(user.getUserName());
                response.setEmail(user.getPrimaryEmail());
                response.setLoginCode(loginCode.getCode());
                return new ResponseEntity((Object)response, HttpStatus.OK);
            }
            catch (BadCredentialsException e) {
                return new ResponseEntity(HttpStatus.UNAUTHORIZED);
            }
            catch (ScimResourceNotFoundException e) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            catch (InvalidCodeException | InvalidPasswordException e) {
                throw e;
            }
            catch (Exception e) {
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        ResponseEntity responseEntity = new ResponseEntity(HttpStatus.BAD_REQUEST);
        return responseEntity;
    }

    private ExpiringCode getCode(String id, String username, String clientId) {
        HashMap<String, String> codeData = new HashMap<String, String>();
        codeData.put("user_id", id);
        codeData.put("username", username);
        codeData.put("client_id", clientId);
        codeData.put("origin", "uaa");
        return this.codeStore.generateCode(JsonUtils.writeValueAsString(codeData), new Timestamp(System.currentTimeMillis() + 300000L), ExpiringCodeType.AUTOLOGIN.name(), IdentityZoneHolder.get().getId());
    }

    @ExceptionHandler(value={InvalidPasswordException.class})
    public View handleException(InvalidPasswordException t) throws ScimException {
        return new ConvertingExceptionView((ResponseEntity<? extends ExceptionReport>)new ResponseEntity((Object)new ExceptionReport(t, false), HttpStatus.UNPROCESSABLE_ENTITY), this.messageConverters);
    }

    @ExceptionHandler(value={InvalidCodeException.class})
    public View handleCodeException(InvalidCodeException t) throws ScimException {
        return new ConvertingExceptionView((ResponseEntity<? extends ExceptionReport>)new ResponseEntity((Object)new ExceptionReport(t, false), HttpStatus.UNPROCESSABLE_ENTITY), this.messageConverters);
    }

    public void setCodeStore(ExpiringCodeStore codeStore) {
        this.codeStore = codeStore;
    }
}

