/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class OperationUtils {
    private OperationUtils() {
    }

    public static Mono<byte[]> collectByteArray(Flux<byte[]> bytes) {
        return bytes.reduceWith(ByteArrayOutputStream::new, (prev, next) -> {
            try {
                prev.write((byte[])next);
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            return prev;
        }).map(ByteArrayOutputStream::toByteArray);
    }
}

