/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.uaa.identityzones._CorsConfiguration;
import org.immutables.value.Generated;

@Generated(from="_CorsConfiguration", generator="Immutables")
public final class CorsConfiguration
extends _CorsConfiguration {
    private final Boolean allowedCredentials;
    private final List<String> allowedHeaders;
    private final List<String> allowedMethods;
    private final List<String> allowedOriginPatterns;
    private final List<String> allowedOrigins;
    private final List<String> allowedUriPatterns;
    private final List<String> allowedUris;
    private final Long maxAge;

    private CorsConfiguration(Builder builder) {
        this.allowedCredentials = builder.allowedCredentials;
        this.allowedHeaders = CorsConfiguration.createUnmodifiableList(true, builder.allowedHeaders);
        this.allowedMethods = CorsConfiguration.createUnmodifiableList(true, builder.allowedMethods);
        this.allowedOriginPatterns = CorsConfiguration.createUnmodifiableList(true, builder.allowedOriginPatterns);
        this.allowedOrigins = CorsConfiguration.createUnmodifiableList(true, builder.allowedOrigins);
        this.allowedUriPatterns = CorsConfiguration.createUnmodifiableList(true, builder.allowedUriPatterns);
        this.allowedUris = CorsConfiguration.createUnmodifiableList(true, builder.allowedUris);
        this.maxAge = builder.maxAge;
    }

    @Override
    @JsonProperty(value="allowedCredentials")
    public Boolean getAllowedCredentials() {
        return this.allowedCredentials;
    }

    @Override
    @JsonProperty(value="allowedHeaders")
    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    @Override
    @JsonProperty(value="allowedMethods")
    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    @Override
    @JsonProperty(value="allowedOriginPatterns")
    public List<String> getAllowedOriginPatterns() {
        return this.allowedOriginPatterns;
    }

    @Override
    @JsonProperty(value="allowedOrigins")
    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    @Override
    @JsonProperty(value="allowedUriPatterns")
    public List<String> getAllowedUriPatterns() {
        return this.allowedUriPatterns;
    }

    @Override
    @JsonProperty(value="allowedUris")
    public List<String> getAllowedUris() {
        return this.allowedUris;
    }

    @Override
    @JsonProperty(value="maxAge")
    public Long getMaxAge() {
        return this.maxAge;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CorsConfiguration && this.equalTo((CorsConfiguration)another);
    }

    private boolean equalTo(CorsConfiguration another) {
        return this.allowedCredentials.equals(another.allowedCredentials) && this.allowedHeaders.equals(another.allowedHeaders) && this.allowedMethods.equals(another.allowedMethods) && this.allowedOriginPatterns.equals(another.allowedOriginPatterns) && this.allowedOrigins.equals(another.allowedOrigins) && this.allowedUriPatterns.equals(another.allowedUriPatterns) && this.allowedUris.equals(another.allowedUris) && this.maxAge.equals(another.maxAge);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.allowedCredentials.hashCode();
        h += (h << 5) + this.allowedHeaders.hashCode();
        h += (h << 5) + this.allowedMethods.hashCode();
        h += (h << 5) + this.allowedOriginPatterns.hashCode();
        h += (h << 5) + this.allowedOrigins.hashCode();
        h += (h << 5) + this.allowedUriPatterns.hashCode();
        h += (h << 5) + this.allowedUris.hashCode();
        h += (h << 5) + this.maxAge.hashCode();
        return h;
    }

    public String toString() {
        return "CorsConfiguration{allowedCredentials=" + this.allowedCredentials + ", allowedHeaders=" + this.allowedHeaders + ", allowedMethods=" + this.allowedMethods + ", allowedOriginPatterns=" + this.allowedOriginPatterns + ", allowedOrigins=" + this.allowedOrigins + ", allowedUriPatterns=" + this.allowedUriPatterns + ", allowedUris=" + this.allowedUris + ", maxAge=" + this.maxAge + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CorsConfiguration fromJson(Json json) {
        Builder builder = CorsConfiguration.builder();
        if (json.allowedCredentials != null) {
            builder.allowedCredentials(json.allowedCredentials);
        }
        if (json.allowedHeaders != null) {
            builder.addAllAllowedHeaders(json.allowedHeaders);
        }
        if (json.allowedMethods != null) {
            builder.addAllAllowedMethods(json.allowedMethods);
        }
        if (json.allowedOriginPatterns != null) {
            builder.addAllAllowedOriginPatterns(json.allowedOriginPatterns);
        }
        if (json.allowedOrigins != null) {
            builder.addAllAllowedOrigins(json.allowedOrigins);
        }
        if (json.allowedUriPatterns != null) {
            builder.addAllAllowedUriPatterns(json.allowedUriPatterns);
        }
        if (json.allowedUris != null) {
            builder.addAllAllowedUris(json.allowedUris);
        }
        if (json.maxAge != null) {
            builder.maxAge(json.maxAge);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_CorsConfiguration", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ALLOWED_CREDENTIALS = 1L;
        private static final long INIT_BIT_MAX_AGE = 2L;
        private long initBits = 3L;
        private Boolean allowedCredentials;
        private List<String> allowedHeaders = new ArrayList<String>();
        private List<String> allowedMethods = new ArrayList<String>();
        private List<String> allowedOriginPatterns = new ArrayList<String>();
        private List<String> allowedOrigins = new ArrayList<String>();
        private List<String> allowedUriPatterns = new ArrayList<String>();
        private List<String> allowedUris = new ArrayList<String>();
        private Long maxAge;

        private Builder() {
        }

        public final Builder from(CorsConfiguration instance) {
            return this.from((_CorsConfiguration)instance);
        }

        final Builder from(_CorsConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.allowedCredentials(instance.getAllowedCredentials());
            this.addAllAllowedHeaders(instance.getAllowedHeaders());
            this.addAllAllowedMethods(instance.getAllowedMethods());
            this.addAllAllowedOriginPatterns(instance.getAllowedOriginPatterns());
            this.addAllAllowedOrigins(instance.getAllowedOrigins());
            this.addAllAllowedUriPatterns(instance.getAllowedUriPatterns());
            this.addAllAllowedUris(instance.getAllowedUris());
            this.maxAge(instance.getMaxAge());
            return this;
        }

        @JsonProperty(value="allowedCredentials")
        public final Builder allowedCredentials(Boolean allowedCredentials) {
            this.allowedCredentials = Objects.requireNonNull(allowedCredentials, "allowedCredentials");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder allowedHeader(String element) {
            this.allowedHeaders.add(Objects.requireNonNull(element, "allowedHeaders element"));
            return this;
        }

        public final Builder allowedHeaders(String ... elements) {
            for (String element : elements) {
                this.allowedHeaders.add(Objects.requireNonNull(element, "allowedHeaders element"));
            }
            return this;
        }

        @JsonProperty(value="allowedHeaders")
        public final Builder allowedHeaders(Iterable<String> elements) {
            this.allowedHeaders.clear();
            return this.addAllAllowedHeaders(elements);
        }

        public final Builder addAllAllowedHeaders(Iterable<String> elements) {
            for (String element : elements) {
                this.allowedHeaders.add(Objects.requireNonNull(element, "allowedHeaders element"));
            }
            return this;
        }

        public final Builder allowedMethod(String element) {
            this.allowedMethods.add(Objects.requireNonNull(element, "allowedMethods element"));
            return this;
        }

        public final Builder allowedMethods(String ... elements) {
            for (String element : elements) {
                this.allowedMethods.add(Objects.requireNonNull(element, "allowedMethods element"));
            }
            return this;
        }

        @JsonProperty(value="allowedMethods")
        public final Builder allowedMethods(Iterable<String> elements) {
            this.allowedMethods.clear();
            return this.addAllAllowedMethods(elements);
        }

        public final Builder addAllAllowedMethods(Iterable<String> elements) {
            for (String element : elements) {
                this.allowedMethods.add(Objects.requireNonNull(element, "allowedMethods element"));
            }
            return this;
        }

        public final Builder allowedOriginPattern(String element) {
            this.allowedOriginPatterns.add(Objects.requireNonNull(element, "allowedOriginPatterns element"));
            return this;
        }

        public final Builder allowedOriginPatterns(String ... elements) {
            for (String element : elements) {
                this.allowedOriginPatterns.add(Objects.requireNonNull(element, "allowedOriginPatterns element"));
            }
            return this;
        }

        @JsonProperty(value="allowedOriginPatterns")
        public final Builder allowedOriginPatterns(Iterable<String> elements) {
            this.allowedOriginPatterns.clear();
            return this.addAllAllowedOriginPatterns(elements);
        }

        public final Builder addAllAllowedOriginPatterns(Iterable<String> elements) {
            for (String element : elements) {
                this.allowedOriginPatterns.add(Objects.requireNonNull(element, "allowedOriginPatterns element"));
            }
            return this;
        }

        public final Builder allowedOrigin(String element) {
            this.allowedOrigins.add(Objects.requireNonNull(element, "allowedOrigins element"));
            return this;
        }

        public final Builder allowedOrigins(String ... elements) {
            for (String element : elements) {
                this.allowedOrigins.add(Objects.requireNonNull(element, "allowedOrigins element"));
            }
            return this;
        }

        @JsonProperty(value="allowedOrigins")
        public final Builder allowedOrigins(Iterable<String> elements) {
            this.allowedOrigins.clear();
            return this.addAllAllowedOrigins(elements);
        }

        public final Builder addAllAllowedOrigins(Iterable<String> elements) {
            for (String element : elements) {
                this.allowedOrigins.add(Objects.requireNonNull(element, "allowedOrigins element"));
            }
            return this;
        }

        public final Builder allowedUriPattern(String element) {
            this.allowedUriPatterns.add(Objects.requireNonNull(element, "allowedUriPatterns element"));
            return this;
        }

        public final Builder allowedUriPatterns(String ... elements) {
            for (String element : elements) {
                this.allowedUriPatterns.add(Objects.requireNonNull(element, "allowedUriPatterns element"));
            }
            return this;
        }

        @JsonProperty(value="allowedUriPatterns")
        public final Builder allowedUriPatterns(Iterable<String> elements) {
            this.allowedUriPatterns.clear();
            return this.addAllAllowedUriPatterns(elements);
        }

        public final Builder addAllAllowedUriPatterns(Iterable<String> elements) {
            for (String element : elements) {
                this.allowedUriPatterns.add(Objects.requireNonNull(element, "allowedUriPatterns element"));
            }
            return this;
        }

        public final Builder allowedUri(String element) {
            this.allowedUris.add(Objects.requireNonNull(element, "allowedUris element"));
            return this;
        }

        public final Builder allowedUris(String ... elements) {
            for (String element : elements) {
                this.allowedUris.add(Objects.requireNonNull(element, "allowedUris element"));
            }
            return this;
        }

        @JsonProperty(value="allowedUris")
        public final Builder allowedUris(Iterable<String> elements) {
            this.allowedUris.clear();
            return this.addAllAllowedUris(elements);
        }

        public final Builder addAllAllowedUris(Iterable<String> elements) {
            for (String element : elements) {
                this.allowedUris.add(Objects.requireNonNull(element, "allowedUris element"));
            }
            return this;
        }

        @JsonProperty(value="maxAge")
        public final Builder maxAge(Long maxAge) {
            this.maxAge = Objects.requireNonNull(maxAge, "maxAge");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CorsConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CorsConfiguration(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("allowedCredentials");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxAge");
            }
            return "Cannot build CorsConfiguration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CorsConfiguration", generator="Immutables")
    static final class Json
    extends _CorsConfiguration {
        Boolean allowedCredentials;
        List<String> allowedHeaders = Collections.emptyList();
        List<String> allowedMethods = Collections.emptyList();
        List<String> allowedOriginPatterns = Collections.emptyList();
        List<String> allowedOrigins = Collections.emptyList();
        List<String> allowedUriPatterns = Collections.emptyList();
        List<String> allowedUris = Collections.emptyList();
        Long maxAge;

        Json() {
        }

        @JsonProperty(value="allowedCredentials")
        public void setAllowedCredentials(Boolean allowedCredentials) {
            this.allowedCredentials = allowedCredentials;
        }

        @JsonProperty(value="allowedHeaders")
        public void setAllowedHeaders(List<String> allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
        }

        @JsonProperty(value="allowedMethods")
        public void setAllowedMethods(List<String> allowedMethods) {
            this.allowedMethods = allowedMethods;
        }

        @JsonProperty(value="allowedOriginPatterns")
        public void setAllowedOriginPatterns(List<String> allowedOriginPatterns) {
            this.allowedOriginPatterns = allowedOriginPatterns;
        }

        @JsonProperty(value="allowedOrigins")
        public void setAllowedOrigins(List<String> allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
        }

        @JsonProperty(value="allowedUriPatterns")
        public void setAllowedUriPatterns(List<String> allowedUriPatterns) {
            this.allowedUriPatterns = allowedUriPatterns;
        }

        @JsonProperty(value="allowedUris")
        public void setAllowedUris(List<String> allowedUris) {
            this.allowedUris = allowedUris;
        }

        @JsonProperty(value="maxAge")
        public void setMaxAge(Long maxAge) {
            this.maxAge = maxAge;
        }

        @Override
        public Boolean getAllowedCredentials() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAllowedHeaders() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAllowedMethods() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAllowedOriginPatterns() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAllowedOrigins() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAllowedUriPatterns() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAllowedUris() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getMaxAge() {
            throw new UnsupportedOperationException();
        }
    }
}

