/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.securitygroups;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum Protocol {
    ALL("all"),
    ICMP("icmp"),
    TCP("tcp"),
    UDP("udp");

    private final String value;

    private Protocol(String value) {
        this.value = value;
    }

    @JsonCreator
    public static Protocol from(String s) {
        switch (s.toLowerCase()) {
            case "all": {
                return ALL;
            }
            case "icmp": {
                return ICMP;
            }
            case "tcp": {
                return TCP;
            }
            case "udp": {
                return UDP;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown protocol: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

