/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.routes._CreateRouteRequest;
import org.immutables.value.Generated;

@Generated(from="_CreateRouteRequest", generator="Immutables")
public final class CreateRouteRequest
extends _CreateRouteRequest {
    private final String domainId;
    @Nullable
    private final Boolean generatePort;
    @Nullable
    private final String host;
    @Nullable
    private final String path;
    @Nullable
    private final Integer port;
    private final String spaceId;

    private CreateRouteRequest(Builder builder) {
        this.domainId = builder.domainId;
        this.generatePort = builder.generatePort;
        this.host = builder.host;
        this.path = builder.path;
        this.port = builder.port;
        this.spaceId = builder.spaceId;
    }

    @Override
    @JsonProperty(value="domain_guid")
    public String getDomainId() {
        return this.domainId;
    }

    @Override
    @JsonIgnore
    @Nullable
    public Boolean getGeneratePort() {
        return this.generatePort;
    }

    @Override
    @JsonProperty(value="host")
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    @JsonProperty(value="path")
    @Nullable
    public String getPath() {
        return this.path;
    }

    @Override
    @JsonProperty(value="port")
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Override
    @JsonProperty(value="space_guid")
    public String getSpaceId() {
        return this.spaceId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateRouteRequest && this.equalTo((CreateRouteRequest)another);
    }

    private boolean equalTo(CreateRouteRequest another) {
        return this.domainId.equals(another.domainId) && Objects.equals(this.generatePort, another.generatePort) && Objects.equals(this.host, another.host) && Objects.equals(this.path, another.path) && Objects.equals(this.port, another.port) && this.spaceId.equals(another.spaceId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.domainId.hashCode();
        h += (h << 5) + Objects.hashCode(this.generatePort);
        h += (h << 5) + Objects.hashCode(this.host);
        h += (h << 5) + Objects.hashCode(this.path);
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + this.spaceId.hashCode();
        return h;
    }

    public String toString() {
        return "CreateRouteRequest{domainId=" + this.domainId + ", generatePort=" + this.generatePort + ", host=" + this.host + ", path=" + this.path + ", port=" + this.port + ", spaceId=" + this.spaceId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateRouteRequest fromJson(Json json) {
        Builder builder = CreateRouteRequest.builder();
        if (json.domainId != null) {
            builder.domainId(json.domainId);
        }
        if (json.generatePort != null) {
            builder.generatePort(json.generatePort);
        }
        if (json.host != null) {
            builder.host(json.host);
        }
        if (json.path != null) {
            builder.path(json.path);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        if (json.spaceId != null) {
            builder.spaceId(json.spaceId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_CreateRouteRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DOMAIN_ID = 1L;
        private static final long INIT_BIT_SPACE_ID = 2L;
        private long initBits = 3L;
        private String domainId;
        private Boolean generatePort;
        private String host;
        private String path;
        private Integer port;
        private String spaceId;

        private Builder() {
        }

        public final Builder from(CreateRouteRequest instance) {
            return this.from((_CreateRouteRequest)instance);
        }

        final Builder from(_CreateRouteRequest instance) {
            Integer portValue;
            String pathValue;
            String hostValue;
            Objects.requireNonNull(instance, "instance");
            this.domainId(instance.getDomainId());
            Boolean generatePortValue = instance.getGeneratePort();
            if (generatePortValue != null) {
                this.generatePort(generatePortValue);
            }
            if ((hostValue = instance.getHost()) != null) {
                this.host(hostValue);
            }
            if ((pathValue = instance.getPath()) != null) {
                this.path(pathValue);
            }
            if ((portValue = instance.getPort()) != null) {
                this.port(portValue);
            }
            this.spaceId(instance.getSpaceId());
            return this;
        }

        public final Builder domainId(String domainId) {
            this.domainId = Objects.requireNonNull(domainId, "domainId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder generatePort(@Nullable Boolean generatePort) {
            this.generatePort = generatePort;
            return this;
        }

        public final Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        public final Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        public final Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        public final Builder spaceId(String spaceId) {
            this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CreateRouteRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateRouteRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("domainId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("spaceId");
            }
            return "Cannot build CreateRouteRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CreateRouteRequest", generator="Immutables")
    static final class Json
    extends _CreateRouteRequest {
        String domainId;
        Boolean generatePort;
        String host;
        String path;
        Integer port;
        String spaceId;

        Json() {
        }

        @JsonProperty(value="domain_guid")
        public void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @JsonIgnore
        public void setGeneratePort(@Nullable Boolean generatePort) {
            this.generatePort = generatePort;
        }

        @JsonProperty(value="host")
        public void setHost(@Nullable String host) {
            this.host = host;
        }

        @JsonProperty(value="path")
        public void setPath(@Nullable String path) {
            this.path = path;
        }

        @JsonProperty(value="port")
        public void setPort(@Nullable Integer port) {
            this.port = port;
        }

        @JsonProperty(value="space_guid")
        public void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public String getDomainId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getGeneratePort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSpaceId() {
            throw new UnsupportedOperationException();
        }
    }
}

