/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.organizations._ListOrganizationDomainsRequest;
import org.immutables.value.Generated;

@Generated(from="_ListOrganizationDomainsRequest", generator="Immutables")
public final class ListOrganizationDomainsRequest
extends _ListOrganizationDomainsRequest {
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;
    @Nullable
    private final List<String> names;
    private final String organizationId;
    @Nullable
    private final List<String> owningOrganizationIds;

    private ListOrganizationDomainsRequest(Builder builder) {
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
        this.names = builder.names == null ? null : ListOrganizationDomainsRequest.createUnmodifiableList(true, builder.names);
        this.organizationId = builder.organizationId;
        this.owningOrganizationIds = builder.owningOrganizationIds == null ? null : ListOrganizationDomainsRequest.createUnmodifiableList(true, builder.owningOrganizationIds);
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    @Override
    @Nullable
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Override
    @Nullable
    public List<String> getOwningOrganizationIds() {
        return this.owningOrganizationIds;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListOrganizationDomainsRequest && this.equalTo((ListOrganizationDomainsRequest)another);
    }

    private boolean equalTo(ListOrganizationDomainsRequest another) {
        return Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage) && Objects.equals(this.names, another.names) && this.organizationId.equals(another.organizationId) && Objects.equals(this.owningOrganizationIds, another.owningOrganizationIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        h += (h << 5) + Objects.hashCode(this.names);
        h += (h << 5) + this.organizationId.hashCode();
        h += (h << 5) + Objects.hashCode(this.owningOrganizationIds);
        return h;
    }

    public String toString() {
        return "ListOrganizationDomainsRequest{orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", names=" + this.names + ", organizationId=" + this.organizationId + ", owningOrganizationIds=" + this.owningOrganizationIds + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListOrganizationDomainsRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ORGANIZATION_ID = 1L;
        private long initBits = 1L;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private List<String> names = null;
        private String organizationId;
        private List<String> owningOrganizationIds = null;

        private Builder() {
        }

        public final Builder from(ListOrganizationDomainsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListOrganizationDomainsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListOrganizationDomainsRequest) {
                List<String> namesValue;
                instance = (_ListOrganizationDomainsRequest)object;
                this.organizationId(((_ListOrganizationDomainsRequest)instance).getOrganizationId());
                List<String> owningOrganizationIdsValue = ((_ListOrganizationDomainsRequest)instance).getOwningOrganizationIds();
                if (owningOrganizationIdsValue != null) {
                    this.addAllOwningOrganizationIds(owningOrganizationIdsValue);
                }
                if ((namesValue = ((_ListOrganizationDomainsRequest)instance).getNames()) != null) {
                    this.addAllNames(namesValue);
                }
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public final Builder name(String element) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.names = null;
                return this;
            }
            this.names = new ArrayList<String>();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "names element");
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder organizationId(String organizationId) {
            this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder owningOrganizationId(String element) {
            if (this.owningOrganizationIds == null) {
                this.owningOrganizationIds = new ArrayList<String>();
            }
            this.owningOrganizationIds.add(Objects.requireNonNull(element, "owningOrganizationIds element"));
            return this;
        }

        public final Builder owningOrganizationIds(String ... elements) {
            if (this.owningOrganizationIds == null) {
                this.owningOrganizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.owningOrganizationIds.add(Objects.requireNonNull(element, "owningOrganizationIds element"));
            }
            return this;
        }

        public final Builder owningOrganizationIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.owningOrganizationIds = null;
                return this;
            }
            this.owningOrganizationIds = new ArrayList<String>();
            return this.addAllOwningOrganizationIds(elements);
        }

        public final Builder addAllOwningOrganizationIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "owningOrganizationIds element");
            if (this.owningOrganizationIds == null) {
                this.owningOrganizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.owningOrganizationIds.add(Objects.requireNonNull(element, "owningOrganizationIds element"));
            }
            return this;
        }

        public ListOrganizationDomainsRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListOrganizationDomainsRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("organizationId");
            }
            return "Cannot build ListOrganizationDomainsRequest, some of required attributes are not set " + attributes;
        }
    }
}

