/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.events._ListEventsRequest;
import org.immutables.value.Generated;

@Generated(from="_ListEventsRequest", generator="Immutables")
public final class ListEventsRequest
extends _ListEventsRequest {
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;
    @Nullable
    private final List<String> actees;
    @Nullable
    private final List<String> organizationIds;
    @Nullable
    private final List<String> spaceIds;
    @Nullable
    private final List<String> timestamps;
    @Nullable
    private final List<String> types;

    private ListEventsRequest(Builder builder) {
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
        this.actees = builder.actees == null ? null : ListEventsRequest.createUnmodifiableList(true, builder.actees);
        this.organizationIds = builder.organizationIds == null ? null : ListEventsRequest.createUnmodifiableList(true, builder.organizationIds);
        this.spaceIds = builder.spaceIds == null ? null : ListEventsRequest.createUnmodifiableList(true, builder.spaceIds);
        this.timestamps = builder.timestamps == null ? null : ListEventsRequest.createUnmodifiableList(true, builder.timestamps);
        this.types = builder.types == null ? null : ListEventsRequest.createUnmodifiableList(true, builder.types);
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    @Override
    @Nullable
    public List<String> getActees() {
        return this.actees;
    }

    @Override
    @Nullable
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @Override
    @Nullable
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    @Override
    @Nullable
    public List<String> getTimestamps() {
        return this.timestamps;
    }

    @Override
    @Nullable
    public List<String> getTypes() {
        return this.types;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListEventsRequest && this.equalTo((ListEventsRequest)another);
    }

    private boolean equalTo(ListEventsRequest another) {
        return Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage) && Objects.equals(this.actees, another.actees) && Objects.equals(this.organizationIds, another.organizationIds) && Objects.equals(this.spaceIds, another.spaceIds) && Objects.equals(this.timestamps, another.timestamps) && Objects.equals(this.types, another.types);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        h += (h << 5) + Objects.hashCode(this.actees);
        h += (h << 5) + Objects.hashCode(this.organizationIds);
        h += (h << 5) + Objects.hashCode(this.spaceIds);
        h += (h << 5) + Objects.hashCode(this.timestamps);
        h += (h << 5) + Objects.hashCode(this.types);
        return h;
    }

    public String toString() {
        return "ListEventsRequest{orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", actees=" + this.actees + ", organizationIds=" + this.organizationIds + ", spaceIds=" + this.spaceIds + ", timestamps=" + this.timestamps + ", types=" + this.types + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListEventsRequest", generator="Immutables")
    public static final class Builder {
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private List<String> actees = null;
        private List<String> organizationIds = null;
        private List<String> spaceIds = null;
        private List<String> timestamps = null;
        private List<String> types = null;

        private Builder() {
        }

        public final Builder from(ListEventsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListEventsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListEventsRequest) {
                List<String> acteesValue;
                List<String> timestampsValue;
                List<String> organizationIdsValue;
                List<String> spaceIdsValue;
                instance = (_ListEventsRequest)object;
                List<String> typesValue = ((_ListEventsRequest)instance).getTypes();
                if (typesValue != null) {
                    this.addAllTypes(typesValue);
                }
                if ((spaceIdsValue = ((_ListEventsRequest)instance).getSpaceIds()) != null) {
                    this.addAllSpaceIds(spaceIdsValue);
                }
                if ((organizationIdsValue = ((_ListEventsRequest)instance).getOrganizationIds()) != null) {
                    this.addAllOrganizationIds(organizationIdsValue);
                }
                if ((timestampsValue = ((_ListEventsRequest)instance).getTimestamps()) != null) {
                    this.addAllTimestamps(timestampsValue);
                }
                if ((acteesValue = ((_ListEventsRequest)instance).getActees()) != null) {
                    this.addAllActees(acteesValue);
                }
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public final Builder actee(String element) {
            if (this.actees == null) {
                this.actees = new ArrayList<String>();
            }
            this.actees.add(Objects.requireNonNull(element, "actees element"));
            return this;
        }

        public final Builder actees(String ... elements) {
            if (this.actees == null) {
                this.actees = new ArrayList<String>();
            }
            for (String element : elements) {
                this.actees.add(Objects.requireNonNull(element, "actees element"));
            }
            return this;
        }

        public final Builder actees(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.actees = null;
                return this;
            }
            this.actees = new ArrayList<String>();
            return this.addAllActees(elements);
        }

        public final Builder addAllActees(Iterable<String> elements) {
            Objects.requireNonNull(elements, "actees element");
            if (this.actees == null) {
                this.actees = new ArrayList<String>();
            }
            for (String element : elements) {
                this.actees.add(Objects.requireNonNull(element, "actees element"));
            }
            return this;
        }

        public final Builder organizationId(String element) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            return this;
        }

        public final Builder organizationIds(String ... elements) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder organizationIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.organizationIds = null;
                return this;
            }
            this.organizationIds = new ArrayList<String>();
            return this.addAllOrganizationIds(elements);
        }

        public final Builder addAllOrganizationIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "organizationIds element");
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder spaceId(String element) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            return this;
        }

        public final Builder spaceIds(String ... elements) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder spaceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.spaceIds = null;
                return this;
            }
            this.spaceIds = new ArrayList<String>();
            return this.addAllSpaceIds(elements);
        }

        public final Builder addAllSpaceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "spaceIds element");
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder timestamp(String element) {
            if (this.timestamps == null) {
                this.timestamps = new ArrayList<String>();
            }
            this.timestamps.add(Objects.requireNonNull(element, "timestamps element"));
            return this;
        }

        public final Builder timestamps(String ... elements) {
            if (this.timestamps == null) {
                this.timestamps = new ArrayList<String>();
            }
            for (String element : elements) {
                this.timestamps.add(Objects.requireNonNull(element, "timestamps element"));
            }
            return this;
        }

        public final Builder timestamps(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.timestamps = null;
                return this;
            }
            this.timestamps = new ArrayList<String>();
            return this.addAllTimestamps(elements);
        }

        public final Builder addAllTimestamps(Iterable<String> elements) {
            Objects.requireNonNull(elements, "timestamps element");
            if (this.timestamps == null) {
                this.timestamps = new ArrayList<String>();
            }
            for (String element : elements) {
                this.timestamps.add(Objects.requireNonNull(element, "timestamps element"));
            }
            return this;
        }

        public final Builder type(String element) {
            if (this.types == null) {
                this.types = new ArrayList<String>();
            }
            this.types.add(Objects.requireNonNull(element, "types element"));
            return this;
        }

        public final Builder types(String ... elements) {
            if (this.types == null) {
                this.types = new ArrayList<String>();
            }
            for (String element : elements) {
                this.types.add(Objects.requireNonNull(element, "types element"));
            }
            return this;
        }

        public final Builder types(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.types = null;
                return this;
            }
            this.types = new ArrayList<String>();
            return this.addAllTypes(elements);
        }

        public final Builder addAllTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "types element");
            if (this.types == null) {
                this.types = new ArrayList<String>();
            }
            for (String element : elements) {
                this.types.add(Objects.requireNonNull(element, "types element"));
            }
            return this;
        }

        public ListEventsRequest build() {
            return new ListEventsRequest(this);
        }
    }
}

