/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.tokens;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum KeyType {
    MAC("MAC"),
    RSA("RSA");

    private final String value;

    private KeyType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static KeyType from(String s) {
        switch (s.toLowerCase()) {
            case "mac": {
                return MAC;
            }
            case "rsa": {
                return RSA;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown key type: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

