/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.identityproviders.Type;
import org.cloudfoundry.uaa.identityzones._MfaConfig;
import org.immutables.value.Generated;

@Generated(from="_MfaConfig", generator="Immutables")
public final class MfaConfig
extends _MfaConfig {
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final List<Type> identityProviders;
    @Nullable
    private final String providerName;

    private MfaConfig(Builder builder) {
        this.enabled = builder.enabled;
        this.identityProviders = builder.identityProviders == null ? null : MfaConfig.createUnmodifiableList(true, builder.identityProviders);
        this.providerName = builder.providerName;
    }

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="identityProviders")
    @Nullable
    public List<Type> getIdentityProviders() {
        return this.identityProviders;
    }

    @Override
    @JsonProperty(value="providerName")
    @Nullable
    public String getProviderName() {
        return this.providerName;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MfaConfig && this.equalTo((MfaConfig)another);
    }

    private boolean equalTo(MfaConfig another) {
        return Objects.equals(this.enabled, another.enabled) && Objects.equals(this.identityProviders, another.identityProviders) && Objects.equals(this.providerName, another.providerName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.enabled);
        h += (h << 5) + Objects.hashCode(this.identityProviders);
        h += (h << 5) + Objects.hashCode(this.providerName);
        return h;
    }

    public String toString() {
        return "MfaConfig{enabled=" + this.enabled + ", identityProviders=" + this.identityProviders + ", providerName=" + this.providerName + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static MfaConfig fromJson(Json json) {
        Builder builder = MfaConfig.builder();
        if (json.enabled != null) {
            builder.enabled(json.enabled);
        }
        if (json.identityProviders != null) {
            builder.addAllIdentityProviders(json.identityProviders);
        }
        if (json.providerName != null) {
            builder.providerName(json.providerName);
        }
        return builder.build();
    }

    private static MfaConfig validate(MfaConfig instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_MfaConfig", generator="Immutables")
    public static final class Builder {
        private Boolean enabled;
        private List<Type> identityProviders = null;
        private String providerName;

        private Builder() {
        }

        public final Builder from(MfaConfig instance) {
            return this.from((_MfaConfig)instance);
        }

        final Builder from(_MfaConfig instance) {
            String providerNameValue;
            List<Type> identityProvidersValue;
            Objects.requireNonNull(instance, "instance");
            Boolean enabledValue = instance.getEnabled();
            if (enabledValue != null) {
                this.enabled(enabledValue);
            }
            if ((identityProvidersValue = instance.getIdentityProviders()) != null) {
                this.addAllIdentityProviders(identityProvidersValue);
            }
            if ((providerNameValue = instance.getProviderName()) != null) {
                this.providerName(providerNameValue);
            }
            return this;
        }

        @JsonProperty(value="enabled")
        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Builder identityProvider(Type element) {
            if (this.identityProviders == null) {
                this.identityProviders = new ArrayList<Type>();
            }
            this.identityProviders.add(Objects.requireNonNull(element, "identityProviders element"));
            return this;
        }

        public final Builder identityProviders(Type ... elements) {
            if (this.identityProviders == null) {
                this.identityProviders = new ArrayList<Type>();
            }
            for (Type element : elements) {
                this.identityProviders.add(Objects.requireNonNull(element, "identityProviders element"));
            }
            return this;
        }

        @JsonProperty(value="identityProviders")
        public final Builder identityProviders(@Nullable Iterable<? extends Type> elements) {
            if (elements == null) {
                this.identityProviders = null;
                return this;
            }
            this.identityProviders = new ArrayList<Type>();
            return this.addAllIdentityProviders(elements);
        }

        public final Builder addAllIdentityProviders(Iterable<? extends Type> elements) {
            Objects.requireNonNull(elements, "identityProviders element");
            if (this.identityProviders == null) {
                this.identityProviders = new ArrayList<Type>();
            }
            for (Type type : elements) {
                this.identityProviders.add(Objects.requireNonNull(type, "identityProviders element"));
            }
            return this;
        }

        @JsonProperty(value="providerName")
        public final Builder providerName(@Nullable String providerName) {
            this.providerName = providerName;
            return this;
        }

        public MfaConfig build() {
            return MfaConfig.validate(new MfaConfig(this));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_MfaConfig", generator="Immutables")
    static final class Json
    extends _MfaConfig {
        Boolean enabled;
        List<Type> identityProviders = null;
        String providerName;

        Json() {
        }

        @JsonProperty(value="enabled")
        public void setEnabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
        }

        @JsonProperty(value="identityProviders")
        public void setIdentityProviders(@Nullable List<Type> identityProviders) {
            this.identityProviders = identityProviders;
        }

        @JsonProperty(value="providerName")
        public void setProviderName(@Nullable String providerName) {
            this.providerName = providerName;
        }

        @Override
        public Boolean getEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Type> getIdentityProviders() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getProviderName() {
            throw new UnsupportedOperationException();
        }
    }
}

