/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum Type {
    INTERNAL("uaa"),
    LDAP("ldap"),
    LOGIN_SERVER("login-server"),
    KEYSTONE("keystone"),
    OAUTH2("oauth2.0"),
    OIDC("oidc1.0"),
    SAML("saml");

    private final String value;

    private Type(String value) {
        this.value = value;
    }

    @JsonCreator
    public static Type from(String s) {
        switch (s.toLowerCase()) {
            case "uaa": {
                return INTERNAL;
            }
            case "keystone": {
                return KEYSTONE;
            }
            case "ldap": {
                return LDAP;
            }
            case "login-server": {
                return LOGIN_SERVER;
            }
            case "oauth2.0": {
                return OAUTH2;
            }
            case "oidc1.0": {
                return OIDC;
            }
            case "saml": {
                return SAML;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown type: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

