/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum HealthCheckType {
    HTTP("http"),
    NONE("none"),
    PORT("port"),
    PROCESS("process");

    private final String value;

    private HealthCheckType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static HealthCheckType from(String s) {
        switch (s.toLowerCase()) {
            case "http": {
                return HTTP;
            }
            case "none": {
                return NONE;
            }
            case "port": {
                return PORT;
            }
            case "process": {
                return PROCESS;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown health check type: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

