/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.jobs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Error;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.jobs.Job;
import org.cloudfoundry.client.v3.jobs.JobState;
import org.cloudfoundry.client.v3.jobs.Warning;
import org.cloudfoundry.client.v3.jobs._GetJobResponse;
import org.immutables.value.Generated;

@Generated(from="_GetJobResponse", generator="Immutables")
public final class GetJobResponse
extends _GetJobResponse {
    private final String createdAt;
    private final String id;
    private final Map<String, Link> links;
    @Nullable
    private final String updatedAt;
    private final List<Error> errors;
    private final String operation;
    private final JobState state;
    private final List<Warning> warnings;

    private GetJobResponse(Builder builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.links = GetJobResponse.createUnmodifiableMap(false, false, builder.links);
        this.updatedAt = builder.updatedAt;
        this.errors = GetJobResponse.createUnmodifiableList(true, builder.errors);
        this.operation = builder.operation;
        this.state = builder.state;
        this.warnings = GetJobResponse.createUnmodifiableList(true, builder.warnings);
    }

    @Override
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="guid")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="errors")
    public List<Error> getErrors() {
        return this.errors;
    }

    @Override
    @JsonProperty(value="operation")
    public String getOperation() {
        return this.operation;
    }

    @Override
    @JsonProperty(value="state")
    public JobState getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="warnings")
    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetJobResponse && this.equalTo((GetJobResponse)another);
    }

    private boolean equalTo(GetJobResponse another) {
        return this.createdAt.equals(another.createdAt) && this.id.equals(another.id) && this.links.equals(another.links) && Objects.equals(this.updatedAt, another.updatedAt) && this.errors.equals(another.errors) && this.operation.equals(another.operation) && this.state.equals((Object)another.state) && this.warnings.equals(another.warnings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + this.errors.hashCode();
        h += (h << 5) + this.operation.hashCode();
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + this.warnings.hashCode();
        return h;
    }

    public String toString() {
        return "GetJobResponse{createdAt=" + this.createdAt + ", id=" + this.id + ", links=" + this.links + ", updatedAt=" + this.updatedAt + ", errors=" + this.errors + ", operation=" + this.operation + ", state=" + (Object)((Object)this.state) + ", warnings=" + this.warnings + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static GetJobResponse fromJson(Json json) {
        Builder builder = GetJobResponse.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.errors != null) {
            builder.addAllErrors(json.errors);
        }
        if (json.operation != null) {
            builder.operation(json.operation);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.warnings != null) {
            builder.addAllWarnings(json.warnings);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_GetJobResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CREATED_AT = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_OPERATION = 4L;
        private static final long INIT_BIT_STATE = 8L;
        private long initBits = 15L;
        private String createdAt;
        private String id;
        private Map<String, Link> links = new LinkedHashMap<String, Link>();
        private String updatedAt;
        private List<Error> errors = new ArrayList<Error>();
        private String operation;
        private JobState state;
        private List<Warning> warnings = new ArrayList<Warning>();

        private Builder() {
        }

        public final Builder from(Job instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetJobResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_GetJobResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Resource instance;
            if (object instanceof Job) {
                instance = (Job)object;
                this.state(((Job)instance).getState());
                this.operation(((Job)instance).getOperation());
                this.addAllErrors(((Job)instance).getErrors());
                this.addAllWarnings(((Job)instance).getWarnings());
            }
            if (object instanceof Resource) {
                instance = (Resource)object;
                this.createdAt(instance.getCreatedAt());
                this.putAllLinks(instance.getLinks());
                this.id(instance.getId());
                String updatedAtValue = instance.getUpdatedAt();
                if (updatedAtValue != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        @JsonProperty(value="created_at")
        public final Builder createdAt(String createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> entries) {
            this.links.clear();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> entries) {
            for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
                String k = e.getKey();
                Link v = e.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="updated_at")
        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Builder error(Error element) {
            this.errors.add(Objects.requireNonNull(element, "errors element"));
            return this;
        }

        public final Builder errors(Error ... elements) {
            for (Error element : elements) {
                this.errors.add(Objects.requireNonNull(element, "errors element"));
            }
            return this;
        }

        @JsonProperty(value="errors")
        public final Builder errors(Iterable<? extends Error> elements) {
            this.errors.clear();
            return this.addAllErrors(elements);
        }

        public final Builder addAllErrors(Iterable<? extends Error> elements) {
            for (Error error : elements) {
                this.errors.add(Objects.requireNonNull(error, "errors element"));
            }
            return this;
        }

        @JsonProperty(value="operation")
        public final Builder operation(String operation) {
            this.operation = Objects.requireNonNull(operation, "operation");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="state")
        public final Builder state(JobState state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder warning(Warning element) {
            this.warnings.add(Objects.requireNonNull(element, "warnings element"));
            return this;
        }

        public final Builder warnings(Warning ... elements) {
            for (Warning element : elements) {
                this.warnings.add(Objects.requireNonNull(element, "warnings element"));
            }
            return this;
        }

        @JsonProperty(value="warnings")
        public final Builder warnings(Iterable<? extends Warning> elements) {
            this.warnings.clear();
            return this.addAllWarnings(elements);
        }

        public final Builder addAllWarnings(Iterable<? extends Warning> elements) {
            for (Warning warning : elements) {
                this.warnings.add(Objects.requireNonNull(warning, "warnings element"));
            }
            return this;
        }

        public GetJobResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetJobResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("operation");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("state");
            }
            return "Cannot build GetJobResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_GetJobResponse", generator="Immutables")
    static final class Json
    extends _GetJobResponse {
        String createdAt;
        String id;
        Map<String, Link> links = Collections.emptyMap();
        String updatedAt;
        List<Error> errors = Collections.emptyList();
        String operation;
        JobState state;
        List<Warning> warnings = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="guid")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="errors")
        public void setErrors(List<Error> errors) {
            this.errors = errors;
        }

        @JsonProperty(value="operation")
        public void setOperation(String operation) {
            this.operation = operation;
        }

        @JsonProperty(value="state")
        public void setState(JobState state) {
            this.state = state;
        }

        @JsonProperty(value="warnings")
        public void setWarnings(List<Warning> warnings) {
            this.warnings = warnings;
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Error> getErrors() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getOperation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JobState getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Warning> getWarnings() {
            throw new UnsupportedOperationException();
        }
    }
}

