/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.domains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.domains._CheckReservedRoutesRequest;
import org.immutables.value.Generated;

@Generated(from="_CheckReservedRoutesRequest", generator="Immutables")
public final class CheckReservedRoutesRequest
extends _CheckReservedRoutesRequest {
    private final String domainId;
    @Nullable
    private final String host;
    @Nullable
    private final String path;
    @Nullable
    private final Integer port;

    private CheckReservedRoutesRequest(Builder builder) {
        this.domainId = builder.domainId;
        this.host = builder.host;
        this.path = builder.path;
        this.port = builder.port;
    }

    @Override
    @JsonProperty(value="domainId")
    @JsonIgnore
    public String getDomainId() {
        return this.domainId;
    }

    @Override
    @JsonIgnore
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    @JsonIgnore
    @Nullable
    public String getPath() {
        return this.path;
    }

    @Override
    @JsonIgnore
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CheckReservedRoutesRequest && this.equalTo((CheckReservedRoutesRequest)another);
    }

    private boolean equalTo(CheckReservedRoutesRequest another) {
        return this.domainId.equals(another.domainId) && Objects.equals(this.host, another.host) && Objects.equals(this.path, another.path) && Objects.equals(this.port, another.port);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.domainId.hashCode();
        h += (h << 5) + Objects.hashCode(this.host);
        h += (h << 5) + Objects.hashCode(this.path);
        h += (h << 5) + Objects.hashCode(this.port);
        return h;
    }

    public String toString() {
        return "CheckReservedRoutesRequest{domainId=" + this.domainId + ", host=" + this.host + ", path=" + this.path + ", port=" + this.port + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CheckReservedRoutesRequest fromJson(Json json) {
        Builder builder = CheckReservedRoutesRequest.builder();
        if (json.domainId != null) {
            builder.domainId(json.domainId);
        }
        if (json.host != null) {
            builder.host(json.host);
        }
        if (json.path != null) {
            builder.path(json.path);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_CheckReservedRoutesRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DOMAIN_ID = 1L;
        private long initBits = 1L;
        private String domainId;
        private String host;
        private String path;
        private Integer port;

        private Builder() {
        }

        public final Builder from(CheckReservedRoutesRequest instance) {
            return this.from((_CheckReservedRoutesRequest)instance);
        }

        final Builder from(_CheckReservedRoutesRequest instance) {
            Integer portValue;
            String pathValue;
            Objects.requireNonNull(instance, "instance");
            this.domainId(instance.getDomainId());
            String hostValue = instance.getHost();
            if (hostValue != null) {
                this.host(hostValue);
            }
            if ((pathValue = instance.getPath()) != null) {
                this.path(pathValue);
            }
            if ((portValue = instance.getPort()) != null) {
                this.port(portValue);
            }
            return this;
        }

        public final Builder domainId(String domainId) {
            this.domainId = Objects.requireNonNull(domainId, "domainId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        public final Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        public final Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        public CheckReservedRoutesRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CheckReservedRoutesRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("domainId");
            }
            return "Cannot build CheckReservedRoutesRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CheckReservedRoutesRequest", generator="Immutables")
    static final class Json
    extends _CheckReservedRoutesRequest {
        String domainId;
        String host;
        String path;
        Integer port;

        Json() {
        }

        @JsonProperty(value="domainId")
        @JsonIgnore
        public void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @JsonIgnore
        public void setHost(@Nullable String host) {
            this.host = host;
        }

        @JsonIgnore
        public void setPath(@Nullable String path) {
            this.path = path;
        }

        @JsonIgnore
        public void setPort(@Nullable Integer port) {
            this.port = port;
        }

        @Override
        public String getDomainId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getPort() {
            throw new UnsupportedOperationException();
        }
    }
}

