/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3._Metadata;
import org.immutables.value.Generated;

@Generated(from="_Metadata", generator="Immutables")
public final class Metadata
extends _Metadata {
    @Nullable
    private final Map<String, String> annotations;
    @Nullable
    private final Map<String, String> labels;

    private Metadata(Builder builder) {
        this.annotations = builder.annotations == null ? null : Metadata.createUnmodifiableMap(false, false, builder.annotations);
        this.labels = builder.labels == null ? null : Metadata.createUnmodifiableMap(false, false, builder.labels);
    }

    @Override
    @JsonInclude
    @JsonProperty(value="annotations")
    @Nullable
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    @JsonInclude
    @JsonProperty(value="labels")
    @Nullable
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Metadata && this.equalTo((Metadata)another);
    }

    private boolean equalTo(Metadata another) {
        return Objects.equals(this.annotations, another.annotations) && Objects.equals(this.labels, another.labels);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.annotations);
        h += (h << 5) + Objects.hashCode(this.labels);
        return h;
    }

    public String toString() {
        return "Metadata{annotations=" + this.annotations + ", labels=" + this.labels + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Metadata fromJson(Json json) {
        Builder builder = Metadata.builder();
        if (json.annotations != null) {
            builder.putAllAnnotations(json.annotations);
        }
        if (json.labels != null) {
            builder.putAllLabels(json.labels);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_Metadata", generator="Immutables")
    public static final class Builder {
        private Map<String, String> annotations = null;
        private Map<String, String> labels = null;

        private Builder() {
        }

        public final Builder from(Metadata instance) {
            return this.from((_Metadata)instance);
        }

        final Builder from(_Metadata instance) {
            Map<String, String> labelsValue;
            Objects.requireNonNull(instance, "instance");
            Map<String, String> annotationsValue = instance.getAnnotations();
            if (annotationsValue != null) {
                this.putAllAnnotations(annotationsValue);
            }
            if ((labelsValue = instance.getLabels()) != null) {
                this.putAllLabels(labelsValue);
            }
            return this;
        }

        public final Builder annotation(String key, String value) {
            if (this.annotations == null) {
                this.annotations = new LinkedHashMap<String, String>();
            }
            this.annotations.put(key, value);
            return this;
        }

        public final Builder annotation(Map.Entry<String, ? extends String> entry) {
            if (this.annotations == null) {
                this.annotations = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.annotations.put(k, v);
            return this;
        }

        @JsonInclude
        @JsonProperty(value="annotations")
        public final Builder annotations(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.annotations = null;
                return this;
            }
            this.annotations = new LinkedHashMap<String, String>();
            return this.putAllAnnotations(entries);
        }

        public final Builder putAllAnnotations(Map<String, ? extends String> entries) {
            if (this.annotations == null) {
                this.annotations = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.annotations.put(k, v);
            }
            return this;
        }

        public final Builder label(String key, String value) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.put(key, value);
            return this;
        }

        public final Builder label(Map.Entry<String, ? extends String> entry) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.labels.put(k, v);
            return this;
        }

        @JsonInclude
        @JsonProperty(value="labels")
        public final Builder labels(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.labels = null;
                return this;
            }
            this.labels = new LinkedHashMap<String, String>();
            return this.putAllLabels(entries);
        }

        public final Builder putAllLabels(Map<String, ? extends String> entries) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.labels.put(k, v);
            }
            return this;
        }

        public Metadata build() {
            return new Metadata(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_Metadata", generator="Immutables")
    static final class Json
    extends _Metadata {
        Map<String, String> annotations = null;
        Map<String, String> labels = null;

        Json() {
        }

        @JsonInclude
        @JsonProperty(value="annotations")
        public void setAnnotations(@Nullable Map<String, String> annotations) {
            this.annotations = annotations;
        }

        @JsonInclude
        @JsonProperty(value="labels")
        public void setLabels(@Nullable Map<String, String> labels) {
            this.labels = labels;
        }

        @Override
        public Map<String, String> getAnnotations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getLabels() {
            throw new UnsupportedOperationException();
        }
    }
}

