/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadLocalRandom;
import jdk.Profile+Annotation;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.MinLen;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.framework.qual.FromByteCode;
import sun.misc.Unsafe;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
@Profile+Annotation(value=1)
public class ForkJoinWorkerThread
extends Thread {
    final @UnknownVal @MinLen(value=0) @LowerBoundUnknown ForkJoinPool pool;
    final ForkJoinPool.WorkQueue workQueue;
    private static final Unsafe U;
    private static final long THREADLOCALS;
    private static final long INHERITABLETHREADLOCALS;
    private static final long INHERITEDACCESSCONTROLCONTEXT;

    @FromByteCode
    protected ForkJoinWorkerThread(@UnknownVal @MinLen(value=0) @LowerBoundUnknown ForkJoinPool var1);

    ForkJoinWorkerThread(ForkJoinPool var1, ThreadGroup var2, AccessControlContext var3);

    @FromByteCode
    public @UnknownVal @MinLen(value=0) @LowerBoundUnknown ForkJoinPool getPool();

    @FromByteCode
    public @UnknownVal @NonNegative @MinLen(value=0) int getPoolIndex();

    @FromByteCode
    protected void onStart();

    @FromByteCode
    protected void onTermination(@UnknownVal @MinLen(value=0) @LowerBoundUnknown Throwable var1);

    @Override
    @FromByteCode
    public void run();

    final void eraseThreadLocals();

    void afterTopLevelExec();

    static;

    static final class InnocuousForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        private static final ThreadGroup innocuousThreadGroup;
        private static final AccessControlContext innocuousACC;

        InnocuousForkJoinWorkerThread(ForkJoinPool pool) {
            super(innocuousThreadGroup, pool, true, true);
        }

        @Override
        protected void onStart() {
            Thread t = Thread.currentThread();
            ThreadLocalRandom.setInheritedAccessControlContext(t, innocuousACC);
        }

        @Override
        public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler x) {
        }

        @Override
        public void setContextClassLoader(ClassLoader cl) {
            if (cl != null && ClassLoader.getSystemClassLoader() != cl) {
                throw new SecurityException("setContextClassLoader");
            }
        }

        static AccessControlContext createACC() {
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, null)});
        }

        static ThreadGroup createGroup() {
            ThreadGroup p;
            ThreadGroup group = Thread.currentThread().getThreadGroup();
            while ((p = group.getParent()) != null) {
                group = p;
            }
            return new ThreadGroup(group, "InnocuousForkJoinWorkerThreadGroup");
        }

        static {
            SecurityManager sm = System.getSecurityManager();
            innocuousThreadGroup = sm == null ? InnocuousForkJoinWorkerThread.createGroup() : AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

                @Override
                public ThreadGroup run() {
                    return InnocuousForkJoinWorkerThread.createGroup();
                }
            });
            ThreadGroup g = innocuousThreadGroup;
            innocuousACC = sm == null ? InnocuousForkJoinWorkerThread.createACC() : AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

                @Override
                public AccessControlContext run() {
                    return InnocuousForkJoinWorkerThread.createACC();
                }
            });
            AccessControlContext accessControlContext = innocuousACC;
        }
    }
}

