/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import jdk.Profile+Annotation;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.MinLen;
import org.checkerframework.checker.index.qual.MinLenBottom;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;

/*
 * Exception performing whole class analysis.
 */
@Profile+Annotation(value=1)
public class ArrayBlockingQueue<@MinLenBottom E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final @UnknownVal @MinLen(value=0) @LowerBoundUnknown long serialVersionUID = -817911632652898426L;
    final @UnknownVal @MinLen(value=0) @LowerBoundUnknown Object @UnknownVal @MinLen(value=0) @LowerBoundUnknown [] items;
    @UnknownVal @NonNegative @MinLen(value=0) int takeIndex;
    @UnknownVal @NonNegative @MinLen(value=0) int putIndex;
    @UnknownVal @NonNegative @MinLen(value=0) int count;
    final @UnknownVal @MinLen(value=0) @LowerBoundUnknown ReentrantLock lock;
    private final @UnknownVal @MinLen(value=0) @LowerBoundUnknown Condition notEmpty;
    private final @UnknownVal @MinLen(value=0) @LowerBoundUnknown Condition notFull;
    transient Itrs itrs;

    @FromByteCode
    final @UnknownVal @MinLen(value=0) @LowerBoundUnknown int dec(@UnknownVal @MinLen(value=0) @LowerBoundUnknown int var1);

    @FromByteCode
    final E itemAt(@UnknownVal @NonNegative @MinLen(value=0) int var1);

    @FromByteCode
    private static void checkNotNull(@UnknownVal @MinLen(value=0) @LowerBoundUnknown Object var0);

    private void enqueue(E var1);

    private E dequeue();

    @FromByteCode
    void removeAt(@UnknownVal @MinLen(value=0) @LowerBoundUnknown int var1);

    @FromByteCode
    public ArrayBlockingQueue(@Positive @UnknownVal @MinLen(value=0) int var1);

    @FromByteCode
    public ArrayBlockingQueue(@Positive @UnknownVal @MinLen(value=0) int var1, @UnknownVal @MinLen(value=0) @LowerBoundUnknown boolean var2);

    @FromByteCode
    public ArrayBlockingQueue(@Positive @UnknownVal @MinLen(value=0) int var1, @UnknownVal @MinLen(value=0) @LowerBoundUnknown boolean var2, @UnknownVal @MinLen(value=0) @LowerBoundUnknown Collection<@MinLenBottom @Positive @BottomVal ? extends E> var3);

    @Override
    @FromByteCode
    public @UnknownVal @MinLen(value=0) @LowerBoundUnknown boolean add(E var1);

    @Override
    @FromByteCode
    public @UnknownVal @MinLen(value=0) @LowerBoundUnknown boolean offer(E var1);

    @Override
    @FromByteCode
    public void put(E var1) throws InterruptedException;

    @Override
    @FromByteCode
    public @UnknownVal @MinLen(value=0) @LowerBoundUnknown boolean offer(E var1, @UnknownVal @MinLen(value=0) @LowerBoundUnknown long var2, @UnknownVal @MinLen(value=0) @LowerBoundUnknown TimeUnit var4) throws InterruptedException;

    @Override
    @FromByteCode
    public E poll();

    @Override
    @FromByteCode
    public E take() throws InterruptedException;

    @Override
    @FromByteCode
    public E poll(@UnknownVal @MinLen(value=0) @LowerBoundUnknown long var1, @UnknownVal @MinLen(value=0) @LowerBoundUnknown TimeUnit var3) throws InterruptedException;

    @Override
    @FromByteCode
    public E peek();

    @Override
    @FromByteCode
    public @UnknownVal @NonNegative @MinLen(value=0) int size();

    @Override
    @FromByteCode
    public @UnknownVal @NonNegative @MinLen(value=0) int remainingCapacity();

    @Override
    @FromByteCode
    public @UnknownVal @MinLen(value=0) @LowerBoundUnknown boolean remove(@UnknownVal @MinLen(value=0) @LowerBoundUnknown Object var1);

    @Override
    @FromByteCode
    public @UnknownVal @MinLen(value=0) @LowerBoundUnknown boolean contains(@UnknownVal @MinLen(value=0) @LowerBoundUnknown Object var1);

    @Override
    @FromByteCode
    public @UnknownVal @MinLen(value=0) @LowerBoundUnknown Object @UnknownVal @MinLen(value=0) @LowerBoundUnknown [] toArray();

    @Override
    @FromByteCode
    public <T> T @UnknownVal @MinLen(value=0) @LowerBoundUnknown [] toArray(T @UnknownVal @MinLen(value=0) @LowerBoundUnknown [] var1);

    @Override
    @SideEffectFree
    @FromByteCode
    public @UnknownVal @MinLen(value=0) @LowerBoundUnknown String toString();

    @Override
    @FromByteCode
    public void clear();

    @Override
    @FromByteCode
    public @UnknownVal @MinLen(value=0) @LowerBoundUnknown int drainTo(@UnknownVal @MinLen(value=0) @LowerBoundUnknown Collection<@UnknownVal @MinLen(value=0) @LowerBoundUnknown ? super E> var1);

    @Override
    @FromByteCode
    public @UnknownVal @MinLen(value=0) @LowerBoundUnknown int drainTo(@UnknownVal @MinLen(value=0) @LowerBoundUnknown Collection<@UnknownVal @MinLen(value=0) @LowerBoundUnknown ? super E> var1, @UnknownVal @MinLen(value=0) @LowerBoundUnknown int var2);

    @Override
    @FromByteCode
    public @UnknownVal @MinLen(value=0) @LowerBoundUnknown Iterator<E> iterator();

    @Override
    public Spliterator<E> spliterator();

    class Itrs {
        int cycles;
        private java.util.concurrent.ArrayBlockingQueue$Itrs.Node head;
        private java.util.concurrent.ArrayBlockingQueue$Itrs.Node sweeper;
        private static final int SHORT_SWEEP_PROBES = 4;
        private static final int LONG_SWEEP_PROBES = 16;

        Itrs(Itr initial) {
            this.register(initial);
        }

        void doSomeSweeping(boolean tryHarder) {
            boolean passedGo;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node p;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node o;
            int probes = tryHarder ? 16 : 4;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node sweeper = this.sweeper;
            if (sweeper == null) {
                o = null;
                p = this.head;
                passedGo = true;
            } else {
                o = sweeper;
                p = o.next;
                passedGo = false;
            }
            while (probes > 0) {
                if (p == null) {
                    if (passedGo) break;
                    o = null;
                    p = this.head;
                    passedGo = true;
                }
                Itr it = (Itr)p.get();
                java.util.concurrent.ArrayBlockingQueue$Itrs.Node next = p.next;
                if (it == null || it.isDetached()) {
                    probes = 16;
                    p.clear();
                    p.next = null;
                    if (o == null) {
                        this.head = next;
                        if (next == null) {
                            ArrayBlockingQueue.this.itrs = null;
                            return;
                        }
                    } else {
                        o.next = next;
                    }
                } else {
                    o = p;
                }
                p = next;
                --probes;
            }
            this.sweeper = p == null ? null : o;
        }

        void register(Itr itr) {
            this.head = new Node(this, itr, (Node)this.head);
        }

        void takeIndexWrapped() {
            ++this.cycles;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node o = null;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node p = this.head;
            while (p != null) {
                Itr it = (Itr)p.get();
                java.util.concurrent.ArrayBlockingQueue$Itrs.Node next = p.next;
                if (it == null || it.takeIndexWrapped()) {
                    p.clear();
                    p.next = null;
                    if (o == null) {
                        this.head = next;
                    } else {
                        o.next = next;
                    }
                } else {
                    o = p;
                }
                p = next;
            }
            if (this.head == null) {
                ArrayBlockingQueue.this.itrs = null;
            }
        }

        void removedAt(int removedIndex) {
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node o = null;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node p = this.head;
            while (p != null) {
                Itr it = (Itr)p.get();
                java.util.concurrent.ArrayBlockingQueue$Itrs.Node next = p.next;
                if (it == null || it.removedAt(removedIndex)) {
                    p.clear();
                    p.next = null;
                    if (o == null) {
                        this.head = next;
                    } else {
                        o.next = next;
                    }
                } else {
                    o = p;
                }
                p = next;
            }
            if (this.head == null) {
                ArrayBlockingQueue.this.itrs = null;
            }
        }

        void queueIsEmpty() {
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node p = this.head;
            while (p != null) {
                Itr it = (Itr)p.get();
                if (it != null) {
                    p.clear();
                    it.shutdown();
                }
                p = p.next;
            }
            this.head = null;
            ArrayBlockingQueue.this.itrs = null;
        }

        void elementDequeued() {
            if (ArrayBlockingQueue.this.count == 0) {
                this.queueIsEmpty();
            } else if (ArrayBlockingQueue.this.takeIndex == 0) {
                this.takeIndexWrapped();
            }
        }

        private class Node
        extends WeakReference<Itr> {
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node next;

            /*
             * WARNING - Possible parameter corruption
             */
            Node(Itr iterator, java.util.concurrent.ArrayBlockingQueue$Itrs.Node next) {
                super(iterator);
                this.next = next;
            }
        }
    }

    /*
     * Exception performing whole class analysis.
     * Exception performing whole class analysis ignored.
     */
    private class Itr
    implements Iterator<E> {
        private int cursor;
        private E nextItem;
        private @UnknownVal @MinLen(value=0) @LowerBoundUnknown int nextIndex;
        private E lastItem;
        private @UnknownVal @MinLen(value=0) @LowerBoundUnknown int lastRet;
        private int prevTakeIndex;
        private int prevCycles;
        private static final int NONE = -1;
        private static final int REMOVED = -2;
        private static final int DETACHED = -3;

        @FromByteCode
        Itr(ArrayBlockingQueue var1);

        boolean isDetached();

        private int incCursor(int var1);

        private boolean invalidated(int var1, int var2, long var3, int var5);

        private void incorporateDequeues();

        private void detach();

        @Override
        @FromByteCode
        public @UnknownVal @MinLen(value=0) @LowerBoundUnknown boolean hasNext();

        private void noNext();

        @Override
        @FromByteCode
        public E next();

        @Override
        @FromByteCode
        public void remove();

        void shutdown();

        private int distance(int var1, int var2, int var3);

        boolean removedAt(int var1);

        boolean takeIndexWrapped();
    }
}

