/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.Consumer;
import jdk.Profile+Annotation;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.MinLen;
import org.checkerframework.checker.index.qual.MinLenBottom;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.GuardedByBottom;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;

/*
 * Exception performing whole class analysis.
 */
@Profile+Annotation(value=1)
public class PriorityQueue<@KeyForBottom E>
extends AbstractQueue<E>
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown long serialVersionUID = -7720805057305804111L;
    private static final @UnknownVal @MinLen(value=0) @LowerBoundUnknown int DEFAULT_INITIAL_CAPACITY = 11;
    transient @UnknownVal @MinLen(value=0) @LowerBoundUnknown Object @UnknownVal @MinLen(value=0) @LowerBoundUnknown [] queue;
    private @UnknownVal @NonNegative @MinLen(value=0) int size;
    private final @UnknownVal @MinLen(value=0) @LowerBoundUnknown Comparator<@UnknownVal @MinLen(value=0) @LowerBoundUnknown ? super E> comparator;
    transient @UnknownVal @MinLen(value=0) @LowerBoundUnknown int modCount;
    private static final @UnknownVal @MinLen(value=0) @LowerBoundUnknown int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    @FromByteCode
    @FromByteCode
    @FromByteCode
    public PriorityQueue();

    @FromByteCode
    @FromByteCode
    @FromByteCode
    public PriorityQueue(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @NonNegative @MinLen(value=0) int var1);

    public PriorityQueue(Comparator<? super E> var1);

    @FromByteCode
    @FromByteCode
    @FromByteCode
    public PriorityQueue(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @NonNegative @MinLen(value=0) int var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown Comparator<@UnknownKeyFor @Nullable @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown ? super E> var2);

    @FromByteCode
    @FromByteCode
    @FromByteCode
    public PriorityQueue(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown Collection<@KeyForBottom @NonNull @Initialized @LockPossiblyHeld @GuardedByBottom @MinLenBottom @Positive @BottomVal ? extends E> var1);

    @FromByteCode
    @FromByteCode
    @FromByteCode
    public PriorityQueue(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown PriorityQueue<@KeyForBottom @NonNull @Initialized @LockPossiblyHeld @GuardedByBottom @MinLenBottom @Positive @BottomVal ? extends E> var1);

    @FromByteCode
    @FromByteCode
    @FromByteCode
    public PriorityQueue(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown SortedSet<@KeyForBottom @NonNull @Initialized @LockPossiblyHeld @GuardedByBottom @MinLenBottom @Positive @BottomVal ? extends E> var1);

    @FromByteCode
    private void initFromPriorityQueue(@UnknownVal @MinLen(value=0) @LowerBoundUnknown PriorityQueue<@MinLenBottom @Positive @BottomVal ? extends E> var1);

    @FromByteCode
    private void initElementsFromCollection(@UnknownVal @MinLen(value=0) @LowerBoundUnknown Collection<@MinLenBottom @Positive @BottomVal ? extends E> var1);

    @FromByteCode
    private void initFromCollection(@UnknownVal @MinLen(value=0) @LowerBoundUnknown Collection<@MinLenBottom @Positive @BottomVal ? extends E> var1);

    @FromByteCode
    private void grow(@UnknownVal @MinLen(value=0) @LowerBoundUnknown int var1);

    @FromByteCode
    private static @UnknownVal @MinLen(value=0) @LowerBoundUnknown int hugeCapacity(@UnknownVal @MinLen(value=0) @LowerBoundUnknown int var0);

    @Override
    @FromByteCode
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown boolean add(E var1);

    @Override
    @FromByteCode
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown boolean offer(E var1);

    @Override
    @FromByteCode
    @FromByteCode
    @FromByteCode
    public @Nullable E peek();

    @FromByteCode
    private @UnknownVal @MinLen(value=0) @LowerBoundUnknown int indexOf(@UnknownVal @MinLen(value=0) @LowerBoundUnknown Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown boolean remove(@Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown Object var1);

    @FromByteCode
    @UnknownVal @MinLen(value=0) @LowerBoundUnknown boolean removeEq(@UnknownVal @MinLen(value=0) @LowerBoundUnknown Object var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown boolean contains(@GuardSatisfied PriorityQueue<E> this, @Nullable @UnknownKeyFor @Initialized @GuardSatisfied @LockPossiblyHeld @UnknownVal @MinLen(value=0) @LowerBoundUnknown Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown Object @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown [] toArray();

    @Override
    @FromByteCode
    @FromByteCode
    @FromByteCode
    public <T> @Nullable T @PolyNull @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown [] toArray(T @PolyNull @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown [] var1);

    @Override
    @FromByteCode
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown Iterator<E> iterator();

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @NonNegative @MinLen(value=0) int size(@GuardSatisfied PriorityQueue<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    @FromByteCode
    public void clear();

    @Override
    @FromByteCode
    @FromByteCode
    @FromByteCode
    public @Nullable E poll();

    @FromByteCode
    private E removeAt(@UnknownVal @MinLen(value=0) @LowerBoundUnknown int var1);

    @FromByteCode
    private void siftUp(@UnknownVal @MinLen(value=0) @LowerBoundUnknown int var1, E var2);

    @FromByteCode
    private void siftUpComparable(@UnknownVal @MinLen(value=0) @LowerBoundUnknown int var1, E var2);

    @FromByteCode
    private void siftUpUsingComparator(@UnknownVal @MinLen(value=0) @LowerBoundUnknown int var1, E var2);

    @FromByteCode
    private void siftDown(@UnknownVal @MinLen(value=0) @LowerBoundUnknown int var1, E var2);

    @FromByteCode
    private void siftDownComparable(@UnknownVal @MinLen(value=0) @LowerBoundUnknown int var1, E var2);

    @FromByteCode
    private void siftDownUsingComparator(@UnknownVal @MinLen(value=0) @LowerBoundUnknown int var1, E var2);

    @FromByteCode
    private void heapify();

    @SideEffectFree
    @FromByteCode
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown Comparator<@UnknownKeyFor @Nullable @Initialized @LockPossiblyHeld @GuardedBy @UnknownVal @MinLen(value=0) @LowerBoundUnknown ? super E> comparator(@GuardSatisfied PriorityQueue<E> this);

    @FromByteCode
    private void writeObject(@UnknownVal @MinLen(value=0) @LowerBoundUnknown ObjectOutputStream var1) throws IOException;

    @FromByteCode
    private void readObject(@UnknownVal @MinLen(value=0) @LowerBoundUnknown ObjectInputStream var1) throws IOException, ClassNotFoundException;

    @Override
    public final Spliterator<E> spliterator();

    /*
     * Exception performing whole class analysis.
     * Exception performing whole class analysis ignored.
     */
    private final class Itr
    implements Iterator<E> {
        private @UnknownVal @MinLen(value=0) @LowerBoundUnknown int cursor;
        private @UnknownVal @MinLen(value=0) @LowerBoundUnknown int lastRet;
        private @UnknownVal @MinLen(value=0) @LowerBoundUnknown ArrayDeque<E> forgetMeNot;
        private E lastRetElt;
        private @UnknownVal @MinLen(value=0) @LowerBoundUnknown int expectedModCount;

        @FromByteCode
        private Itr(PriorityQueue var1);

        @Override
        @FromByteCode
        public @UnknownVal @MinLen(value=0) @LowerBoundUnknown boolean hasNext();

        @Override
        @FromByteCode
        public E next();

        @Override
        @FromByteCode
        public void remove();
    }

    final class PriorityQueueSpliterator
    implements Spliterator<E> {
        private int index;
        private int fence;
        private int expectedModCount;

        PriorityQueueSpliterator(int origin, int fence, int expectedModCount) {
            this.index = origin;
            this.fence = fence;
            this.expectedModCount = expectedModCount;
        }

        private int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                this.expectedModCount = PriorityQueue.this.modCount;
                hi = this.fence = PriorityQueue.this.size;
            }
            return hi;
        }

        public PriorityQueueSpliterator trySplit() {
            PriorityQueueSpliterator priorityQueueSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                priorityQueueSpliterator = null;
            } else {
                this.index = mid;
                PriorityQueueSpliterator priorityQueueSpliterator2 = new PriorityQueueSpliterator(lo, this.index, this.expectedModCount);
                priorityQueueSpliterator = priorityQueueSpliterator2;
            }
            return priorityQueueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Object e;
            int hi;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.fence < 0) {
                this.fence = PriorityQueue.this.size;
                this.expectedModCount = PriorityQueue.this.modCount;
            }
            Object[] es = PriorityQueue.this.queue;
            this.index = hi = this.fence;
            for (int i = this.index; i < hi && (e = es[i]) != null; ++i) {
                action.accept(e);
            }
            if (PriorityQueue.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.fence < 0) {
                this.fence = PriorityQueue.this.size;
                this.expectedModCount = PriorityQueue.this.modCount;
            }
            if ((i = this.index) < this.fence) {
                this.index = i + 1;
                Object e = PriorityQueue.this.queue[i];
                if (e == null || PriorityQueue.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                action.accept(e);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16704;
        }
    }
}

