/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import jdk.Profile+Annotation;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.GuardedByBottom;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.lock.qual.ReleasesNoLocks;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;

/*
 * Exception performing whole class analysis.
 */
@Profile+Annotation(value=1)
public class Vector<@KeyForBottom E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy long serialVersionUID = -2767605614048989439L;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    @FromByteCode
    @FromByteCode
    public Vector(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var2);

    @FromByteCode
    @FromByteCode
    public Vector(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @FromByteCode
    @FromByteCode
    public Vector();

    @FromByteCode
    @FromByteCode
    public Vector(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Collection<@KeyForBottom @NonNull @Initialized @LockPossiblyHeld @GuardedByBottom ? extends E> var1);

    @FromByteCode
    @FromByteCode
    public synchronized void copyInto(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Object @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy [] var1);

    @FromByteCode
    @FromByteCode
    public synchronized void trimToSize();

    @FromByteCode
    @FromByteCode
    public synchronized void ensureCapacity(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    private void ensureCapacityHelper(int var1);

    private void grow(int var1);

    private static int hugeCapacity(int var0);

    @FromByteCode
    @FromByteCode
    public synchronized void setSize(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int capacity();

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int size(@GuardSatisfied Vector<E> this);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean isEmpty(@GuardSatisfied Vector<E> this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Enumeration<E> elements();

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean contains(@GuardSatisfied Vector<E> this, @Nullable @UnknownKeyFor @Initialized @GuardSatisfied @LockPossiblyHeld Object var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int indexOf(@GuardSatisfied Vector<E> this, @Nullable @UnknownKeyFor @Initialized @GuardSatisfied @LockPossiblyHeld Object var1);

    @Pure
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int indexOf(@GuardSatisfied Vector<E> this, @Nullable @UnknownKeyFor @Initialized @GuardSatisfied @LockPossiblyHeld Object var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var2);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int lastIndexOf(@GuardSatisfied Vector<E> this, @Nullable @UnknownKeyFor @Initialized @GuardSatisfied @LockPossiblyHeld Object var1);

    @Pure
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int lastIndexOf(@GuardSatisfied Vector<E> this, @Nullable @UnknownKeyFor @Initialized @GuardSatisfied @LockPossiblyHeld Object var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var2);

    @FromByteCode
    @FromByteCode
    public synchronized E elementAt(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @FromByteCode
    @FromByteCode
    public synchronized E firstElement();

    @FromByteCode
    @FromByteCode
    public synchronized E lastElement();

    @FromByteCode
    @FromByteCode
    public synchronized void setElementAt(E var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var2);

    @FromByteCode
    @FromByteCode
    public synchronized void removeElementAt(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @FromByteCode
    @FromByteCode
    public synchronized void insertElementAt(E var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var2);

    @FromByteCode
    @FromByteCode
    public synchronized void addElement(E var1);

    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean removeElement(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Object var1);

    @FromByteCode
    @FromByteCode
    public synchronized void removeAllElements();

    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Object clone(@GuardSatisfied Vector<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public synchronized @Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy Object @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy [] toArray();

    @Override
    @FromByteCode
    @FromByteCode
    public synchronized <T> @Nullable T @PolyNull @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy [] toArray(T @PolyNull @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy [] var1);

    E elementData(int var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public synchronized E get(@GuardSatisfied Vector<E> this, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @Override
    @FromByteCode
    @FromByteCode
    public synchronized E set(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, E var2);

    @Override
    @FromByteCode
    @ReleasesNoLocks
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean add(E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean remove(@Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy Object var1);

    @Override
    @FromByteCode
    @ReleasesNoLocks
    @FromByteCode
    public void add(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, E var2);

    @Override
    @FromByteCode
    @ReleasesNoLocks
    @FromByteCode
    public synchronized E remove(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @Override
    @FromByteCode
    @FromByteCode
    public void clear();

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean containsAll(@GuardSatisfied Vector<E> this, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @GuardSatisfied @LockPossiblyHeld Collection<@UnknownKeyFor @Nullable @Initialized @KeyForBottom @NonNull @Initialized @LockPossiblyHeld @GuardedBy @LockPossiblyHeld @GuardedByBottom ?> var1);

    @Override
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean addAll(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Collection<@KeyForBottom @NonNull @Initialized @LockPossiblyHeld @GuardedByBottom ? extends E> var1);

    @Override
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean removeAll(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Collection<@UnknownKeyFor @Nullable @Initialized @KeyForBottom @NonNull @Initialized @LockPossiblyHeld @GuardedBy @LockPossiblyHeld @GuardedByBottom ?> var1);

    @Override
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean retainAll(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Collection<@UnknownKeyFor @Nullable @Initialized @KeyForBottom @NonNull @Initialized @LockPossiblyHeld @GuardedBy @LockPossiblyHeld @GuardedByBottom ?> var1);

    @Override
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean addAll(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Collection<@KeyForBottom @NonNull @Initialized @LockPossiblyHeld @GuardedByBottom ? extends E> var2);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean equals(@GuardSatisfied Vector<E> this, @Nullable @UnknownKeyFor @Initialized @GuardSatisfied @LockPossiblyHeld Object var1);

    @Override
    @Pure
    @FromByteCode
    @Pure
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int hashCode(@GuardSatisfied Vector<E> this);

    @Override
    @SideEffectFree
    @FromByteCode
    @SideEffectFree
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String toString(@GuardSatisfied Vector<E> this);

    @Override
    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy List<E> subList(@GuardSatisfied Vector<E> this, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var2);

    @Override
    protected synchronized void removeRange(int var1, int var2);

    private void writeObject(ObjectOutputStream var1) throws IOException;

    @Override
    public synchronized ListIterator<E> listIterator(int var1);

    @Override
    public synchronized ListIterator<E> listIterator();

    @Override
    public synchronized Iterator<E> iterator();

    @Override
    public synchronized void forEach(Consumer<? super E> var1);

    @Override
    public synchronized boolean removeIf(Predicate<? super E> var1);

    @Override
    public synchronized void replaceAll(UnaryOperator<E> var1);

    @Override
    public synchronized void sort(Comparator<? super E> var1);

    @Override
    public Spliterator<E> spliterator();

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = Vector.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != Vector.this.elementCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                int i = this.cursor;
                if (i >= Vector.this.elementCount) {
                    throw new NoSuchElementException();
                }
                this.cursor = i + 1;
                this.lastRet = i;
                return Vector.this.elementData(this.lastRet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                Vector.this.remove(this.lastRet);
                this.expectedModCount = Vector.this.modCount;
            }
            this.cursor = this.lastRet;
            this.lastRet = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            Vector vector = Vector.this;
            synchronized (vector) {
                int size = Vector.this.elementCount;
                int i = this.cursor;
                if (i >= size) {
                    return;
                }
                Object[] es = Vector.this.elementData;
                if (i >= es.length) {
                    throw new ConcurrentModificationException();
                }
                while (i < size && Vector.this.modCount == this.expectedModCount) {
                    action.accept(Vector.elementAt((Object[])es, (int)i++));
                }
                this.cursor = i;
                this.lastRet = i - 1;
                this.checkForComodification();
            }
        }

        final void checkForComodification() {
            if (Vector.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    final class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E previous() {
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                int i = this.cursor - 1;
                if (i < 0) {
                    throw new NoSuchElementException();
                }
                this.cursor = i;
                this.lastRet = i;
                return Vector.this.elementData(this.lastRet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(E e) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                Vector.this.set(this.lastRet, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(E e) {
            int i = this.cursor;
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                Vector.this.add(i, e);
                this.expectedModCount = Vector.this.modCount;
            }
            this.cursor = i + 1;
            this.lastRet = -1;
        }
    }

    final class VectorSpliterator
    implements Spliterator<E> {
        private Object[] array;
        private int index;
        private int fence;
        private int expectedModCount;

        VectorSpliterator(Object[] array, int origin, int fence, int expectedModCount) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.expectedModCount = expectedModCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                Vector vector = Vector.this;
                synchronized (vector) {
                    this.array = Vector.this.elementData;
                    this.expectedModCount = Vector.this.modCount;
                    hi = this.fence = Vector.this.elementCount;
                }
            }
            return hi;
        }

        @Override
        public Spliterator<E> trySplit() {
            VectorSpliterator vectorSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                vectorSpliterator = null;
            } else {
                this.index = mid;
                VectorSpliterator vectorSpliterator2 = new VectorSpliterator(this.array, lo, this.index, this.expectedModCount);
                vectorSpliterator = vectorSpliterator2;
            }
            return vectorSpliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            int i = this.index;
            if (this.getFence() > i) {
                this.index = i + 1;
                action.accept(this.array[i]);
                if (Vector.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            int hi = this.getFence();
            Object[] a = this.array;
            this.index = hi;
            for (int i = this.index; i < hi; ++i) {
                action.accept(a[i]);
            }
            if (Vector.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }
}

