/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.Consumer;
import jdk.Profile+Annotation;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;

/*
 * Exception performing whole class analysis.
 */
@I
@Profile+Annotation(value=1)
public class PriorityQueue<@KeyForBottom E>
extends AbstractQueue<E>
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable long serialVersionUID = -7720805057305804111L;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    transient Object[] queue;
    private int size;
    private final Comparator<? super E> comparator;
    transient int modCount;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    @FromByteCode
    @FromByteCode
    public PriorityQueue();

    @FromByteCode
    @FromByteCode
    public PriorityQueue(@UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int var1);

    public PriorityQueue(Comparator<? super E> var1);

    @FromByteCode
    @FromByteCode
    public PriorityQueue(@UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int var1, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @org.checkerframework.checker.javari.qual.Mutable Comparator<@UnknownKeyFor @Nullable @Initialized @ReadOnly ? super E> var2);

    @FromByteCode
    @FromByteCode
    public @PolyRead PriorityQueue(@UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @PolyRead Collection<@KeyForBottom @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable ? extends E> var1);

    @FromByteCode
    @FromByteCode
    public @PolyRead PriorityQueue(@UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @PolyRead PriorityQueue<@KeyForBottom @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable ? extends E> var1);

    @FromByteCode
    @FromByteCode
    public @PolyRead PriorityQueue(@UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @PolyRead SortedSet<@KeyForBottom @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable ? extends E> var1);

    private void initFromPriorityQueue(PriorityQueue<? extends E> var1);

    private void initElementsFromCollection(Collection<? extends E> var1);

    private void initFromCollection(Collection<? extends E> var1);

    private void grow(int var1);

    private static int hugeCapacity(int var0);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean add(@Mutable PriorityQueue<E> this, E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean offer(@Mutable PriorityQueue<E> this, E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E peek(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this);

    private int indexOf(Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean remove(@Mutable PriorityQueue<E> this, @Nullable @UnknownKeyFor @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    boolean removeEq(Object var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean contains(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this, @Nullable @UnknownKeyFor @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable Object @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable [] toArray(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public <T> @Nullable T @PolyNull @UnknownKeyFor @Initialized @org.checkerframework.checker.javari.qual.Mutable [] toArray(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this, T @PolyNull @UnknownKeyFor @Initialized @org.checkerframework.checker.javari.qual.Mutable [] var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @I @PolyRead Iterator<E> iterator(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int size(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public void clear(@Mutable PriorityQueue<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E poll(@Mutable PriorityQueue<E> this);

    private E removeAt(int var1);

    private void siftUp(int var1, E var2);

    private void siftUpComparable(int var1, E var2);

    private void siftUpUsingComparator(int var1, E var2);

    private void siftDown(int var1, E var2);

    private void siftDownComparable(int var1, E var2);

    private void siftDownUsingComparator(int var1, E var2);

    private void heapify();

    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @org.checkerframework.checker.javari.qual.Mutable Comparator<@UnknownKeyFor @Nullable @Initialized @ReadOnly ? super E> comparator(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this);

    private void writeObject(ObjectOutputStream var1) throws IOException;

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    @Override
    public final Spliterator<E> spliterator();

    private final class Itr
    implements Iterator<E> {
        private int cursor;
        private int lastRet = -1;
        private ArrayDeque<E> forgetMeNot;
        private E lastRetElt;
        private int expectedModCount;

        Itr() {
            this.expectedModCount = PriorityQueue.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < PriorityQueue.this.size || this.forgetMeNot != null && !this.forgetMeNot.isEmpty();
        }

        @Override
        public E next() {
            if (this.expectedModCount != PriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.cursor < PriorityQueue.this.size) {
                this.lastRet = this.cursor++;
                return PriorityQueue.this.queue[this.lastRet];
            }
            if (this.forgetMeNot != null) {
                this.lastRet = -1;
                this.lastRetElt = this.forgetMeNot.poll();
                if (this.lastRetElt != null) {
                    return this.lastRetElt;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.expectedModCount != PriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet != -1) {
                Object moved = PriorityQueue.this.removeAt(this.lastRet);
                this.lastRet = -1;
                if (moved == null) {
                    --this.cursor;
                } else {
                    if (this.forgetMeNot == null) {
                        this.forgetMeNot = new ArrayDeque();
                    }
                    this.forgetMeNot.add(moved);
                }
            } else if (this.lastRetElt != null) {
                PriorityQueue.this.removeEq(this.lastRetElt);
                this.lastRetElt = null;
            } else {
                throw new IllegalStateException();
            }
            this.expectedModCount = PriorityQueue.this.modCount;
        }
    }

    final class PriorityQueueSpliterator
    implements Spliterator<E> {
        private int index;
        private int fence;
        private int expectedModCount;

        PriorityQueueSpliterator(int origin, int fence, int expectedModCount) {
            this.index = origin;
            this.fence = fence;
            this.expectedModCount = expectedModCount;
        }

        private int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                this.expectedModCount = PriorityQueue.this.modCount;
                hi = this.fence = PriorityQueue.this.size;
            }
            return hi;
        }

        public PriorityQueueSpliterator trySplit() {
            PriorityQueueSpliterator priorityQueueSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                priorityQueueSpliterator = null;
            } else {
                this.index = mid;
                PriorityQueueSpliterator priorityQueueSpliterator2 = new PriorityQueueSpliterator(lo, this.index, this.expectedModCount);
                priorityQueueSpliterator = priorityQueueSpliterator2;
            }
            return priorityQueueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Object e;
            int hi;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.fence < 0) {
                this.fence = PriorityQueue.this.size;
                this.expectedModCount = PriorityQueue.this.modCount;
            }
            Object[] es = PriorityQueue.this.queue;
            this.index = hi = this.fence;
            for (int i = this.index; i < hi && (e = es[i]) != null; ++i) {
                action.accept(e);
            }
            if (PriorityQueue.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.fence < 0) {
                this.fence = PriorityQueue.this.size;
                this.expectedModCount = PriorityQueue.this.modCount;
            }
            if ((i = this.index) < this.fence) {
                this.index = i + 1;
                Object e = PriorityQueue.this.queue[i];
                if (e == null || PriorityQueue.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                action.accept(e);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16704;
        }
    }
}

