/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import jdk.Profile+Annotation;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

/*
 * Exception performing whole class analysis.
 */
@I
@Profile+Annotation(value=1)
public class Vector<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public Vector(int var1, int var2);

    public Vector(int var1);

    public Vector();

    public @PolyRead Vector(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead Collection<? extends E> var1);

    public synchronized void copyInto(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object @Mutable @org.checkerframework.checker.javari.qual.Mutable [] var1);

    public synchronized void trimToSize(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this);

    public synchronized void ensureCapacity(int var1);

    private void ensureCapacityHelper(int var1);

    private void grow(int var1);

    private static int hugeCapacity(int var0);

    public synchronized void setSize(@Mutable Vector<E> this, int var1);

    public synchronized int capacity(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this);

    @Override
    @Pure
    public synchronized int size(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this);

    @Override
    @Pure
    public synchronized boolean isEmpty(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this);

    public @PolyRead Enumeration<E> elements(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this);

    @Override
    @Pure
    public boolean contains(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @Pure
    public int indexOf(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Pure
    public synchronized int indexOf(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1, int var2);

    @Override
    @Pure
    public synchronized int lastIndexOf(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Pure
    public synchronized int lastIndexOf(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1, int var2);

    public synchronized E elementAt(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, int var1);

    public synchronized E firstElement(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this);

    public synchronized E lastElement(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this);

    public synchronized void setElementAt(@Mutable Vector<E> this, E var1, int var2);

    public synchronized void removeElementAt(@Mutable Vector<E> this, int var1);

    public synchronized void insertElementAt(@Mutable Vector<E> this, E var1, int var2);

    public synchronized void addElement(@Mutable Vector<E> this, E var1);

    public synchronized boolean removeElement(@Mutable Vector<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    public synchronized void removeAllElements(@Mutable Vector<E> this);

    @SideEffectFree
    public synchronized @I(value="N") Object clone();

    @Override
    public synchronized @Nullable Object[] toArray(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this);

    @Override
    public synchronized <T> @Nullable T @PolyNull [] toArray(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, T @PolyNull [] var1);

    E elementData(int var1);

    @Override
    @Pure
    public synchronized E get(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, int var1);

    @Override
    public synchronized E set(@Mutable Vector<E> this, int var1, E var2);

    @Override
    public synchronized boolean add(@Mutable Vector<E> this, E var1);

    @Override
    public boolean remove(@Mutable Vector<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    public void add(@Mutable Vector<E> this, int var1, E var2);

    @Override
    public synchronized E remove(@Mutable Vector<E> this, int var1);

    @Override
    public void clear(@Mutable Vector<E> this);

    @Override
    @Pure
    public synchronized boolean containsAll(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<?> var1);

    @Override
    public synchronized boolean addAll(@Mutable Vector<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> var1);

    @Override
    public synchronized boolean removeAll(@Mutable Vector<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<?> var1);

    @Override
    public synchronized boolean retainAll(@Mutable Vector<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<?> var1);

    @Override
    public synchronized boolean addAll(@Mutable Vector<E> this, int var1, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> var2);

    @Override
    @Pure
    public synchronized boolean equals(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @Pure
    public synchronized int hashCode(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this);

    @Override
    @SideEffectFree
    public synchronized String toString(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this);

    @Override
    @SideEffectFree
    public synchronized @I @PolyRead List<E> subList(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, int var1, int var2);

    @Override
    protected synchronized void removeRange(int var1, int var2);

    private void writeObject(ObjectOutputStream var1) throws IOException;

    @Override
    public synchronized ListIterator<E> listIterator(int var1);

    @Override
    public synchronized ListIterator<E> listIterator();

    @Override
    public synchronized Iterator<E> iterator();

    @Override
    public synchronized void forEach(Consumer<? super E> var1);

    @Override
    public synchronized boolean removeIf(Predicate<? super E> var1);

    @Override
    public synchronized void replaceAll(UnaryOperator<E> var1);

    @Override
    public synchronized void sort(Comparator<? super E> var1);

    @Override
    public Spliterator<E> spliterator();

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = Vector.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != Vector.this.elementCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                int i = this.cursor;
                if (i >= Vector.this.elementCount) {
                    throw new NoSuchElementException();
                }
                this.cursor = i + 1;
                this.lastRet = i;
                return Vector.this.elementData(this.lastRet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                Vector.this.remove(this.lastRet);
                this.expectedModCount = Vector.this.modCount;
            }
            this.cursor = this.lastRet;
            this.lastRet = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            Vector vector = Vector.this;
            synchronized (vector) {
                int size = Vector.this.elementCount;
                int i = this.cursor;
                if (i >= size) {
                    return;
                }
                Object[] es = Vector.this.elementData;
                if (i >= es.length) {
                    throw new ConcurrentModificationException();
                }
                while (i < size && Vector.this.modCount == this.expectedModCount) {
                    action.accept(Vector.elementAt((Object[])es, (int)i++));
                }
                this.cursor = i;
                this.lastRet = i - 1;
                this.checkForComodification();
            }
        }

        final void checkForComodification() {
            if (Vector.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    final class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E previous() {
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                int i = this.cursor - 1;
                if (i < 0) {
                    throw new NoSuchElementException();
                }
                this.cursor = i;
                this.lastRet = i;
                return Vector.this.elementData(this.lastRet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(E e) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                Vector.this.set(this.lastRet, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(E e) {
            int i = this.cursor;
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                Vector.this.add(i, e);
                this.expectedModCount = Vector.this.modCount;
            }
            this.cursor = i + 1;
            this.lastRet = -1;
        }
    }

    final class VectorSpliterator
    implements Spliterator<E> {
        private Object[] array;
        private int index;
        private int fence;
        private int expectedModCount;

        VectorSpliterator(Object[] array, int origin, int fence, int expectedModCount) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.expectedModCount = expectedModCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                Vector vector = Vector.this;
                synchronized (vector) {
                    this.array = Vector.this.elementData;
                    this.expectedModCount = Vector.this.modCount;
                    hi = this.fence = Vector.this.elementCount;
                }
            }
            return hi;
        }

        @Override
        public Spliterator<E> trySplit() {
            VectorSpliterator vectorSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                vectorSpliterator = null;
            } else {
                this.index = mid;
                VectorSpliterator vectorSpliterator2 = new VectorSpliterator(this.array, lo, this.index, this.expectedModCount);
                vectorSpliterator = vectorSpliterator2;
            }
            return vectorSpliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            int i = this.index;
            if (this.getFence() > i) {
                this.index = i + 1;
                action.accept(this.array[i]);
                if (Vector.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            int hi = this.getFence();
            Object[] a = this.array;
            this.index = hi;
            for (int i = this.index; i < hi; ++i) {
                action.accept(a[i]);
            }
            if (Vector.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }
}

