/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Set;
import java.util.spi.LocaleNameProvider;
import jdk.Profile+Annotation;
import jdk.internal.vm.annotation.Stable;
import org.checkerframework.checker.igj.qual.Immutable;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import sun.util.locale.BaseLocale;
import sun.util.locale.InternalLocaleBuilder;
import sun.util.locale.LanguageTag;
import sun.util.locale.LocaleExtensions;
import sun.util.locale.LocaleMatcher;
import sun.util.locale.LocaleObjectCache;
import sun.util.locale.LocaleSyntaxException;
import sun.util.locale.ParseStatus;
import sun.util.locale.provider.LocaleServiceProviderPool;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
@Immutable
@Profile+Annotation(value=1)
public final class Locale
implements Cloneable,
Serializable {
    private static final Cache LOCALECACHE;
    public static final Locale ENGLISH;
    public static final Locale FRENCH;
    public static final Locale GERMAN;
    public static final Locale ITALIAN;
    public static final Locale JAPANESE;
    public static final Locale KOREAN;
    public static final Locale CHINESE;
    public static final Locale SIMPLIFIED_CHINESE;
    public static final Locale TRADITIONAL_CHINESE;
    public static final Locale FRANCE;
    public static final Locale GERMANY;
    public static final Locale ITALY;
    public static final Locale JAPAN;
    public static final Locale KOREA;
    public static final Locale CHINA;
    public static final Locale PRC;
    public static final Locale TAIWAN;
    public static final Locale UK;
    public static final Locale US;
    public static final Locale CANADA;
    public static final Locale CANADA_FRENCH;
    public static final Locale ROOT;
    public static final char PRIVATE_USE_EXTENSION = 'x';
    public static final char UNICODE_LOCALE_EXTENSION = 'u';
    static final long serialVersionUID = 9149081749638150636L;
    private static final int DISPLAY_LANGUAGE = 0;
    private static final int DISPLAY_COUNTRY = 1;
    private static final int DISPLAY_VARIANT = 2;
    private static final int DISPLAY_SCRIPT = 3;
    private transient BaseLocale baseLocale;
    private transient LocaleExtensions localeExtensions;
    private volatile transient int hashCodeValue;
    private static volatile Locale defaultLocale;
    private static volatile Locale defaultDisplayLocale;
    private static volatile Locale defaultFormatLocale;
    private volatile transient String languageTag;
    private static final ObjectStreamField[] serialPersistentFields;
    private static volatile String[] isoLanguages;
    private static volatile String[] isoCountries;

    private Locale(BaseLocale var1, LocaleExtensions var2);

    public Locale(String var1, String var2, String var3);

    public Locale(String var1, String var2);

    public Locale(String var1);

    private static Locale createConstant(String var0, String var1);

    static Locale getInstance(String var0, String var1, String var2);

    static Locale getInstance(String var0, String var1, String var2, String var3, LocaleExtensions var4);

    static Locale getInstance(BaseLocale var0, LocaleExtensions var1);

    public static Locale getDefault();

    public static Locale getDefault(Category var0);

    private static Locale initDefault();

    private static Locale initDefault(Category var0);

    public static synchronized void setDefault(Locale var0);

    public static synchronized void setDefault(Category var0, Locale var1);

    public static Locale @org.checkerframework.checker.igj.qual.ReadOnly [] getAvailableLocales();

    public static String @org.checkerframework.checker.igj.qual.ReadOnly [] getISOCountries();

    public static String @org.checkerframework.checker.igj.qual.ReadOnly [] getISOLanguages();

    private static String[] getISO2Table(String var0);

    public String getLanguage(@ReadOnly Locale this);

    public String getScript();

    public String getCountry(@ReadOnly Locale this);

    public String getVariant(@ReadOnly Locale this);

    public boolean hasExtensions();

    public Locale stripExtensions();

    public String getExtension(char var1);

    public Set<Character> getExtensionKeys();

    public Set<String> getUnicodeLocaleAttributes();

    public String getUnicodeLocaleType(String var1);

    public Set<String> getUnicodeLocaleKeys();

    BaseLocale getBaseLocale();

    LocaleExtensions getLocaleExtensions();

    @SideEffectFree
    public final String toString(@ReadOnly Locale this);

    public String toLanguageTag();

    public static Locale forLanguageTag(String var0);

    public String getISO3Language(@ReadOnly Locale this) throws MissingResourceException;

    public String getISO3Country(@ReadOnly Locale this) throws MissingResourceException;

    private static String getISO3Code(String var0, String var1);

    public final String getDisplayLanguage();

    public String getDisplayLanguage(@ReadOnly Locale this, Locale var1);

    public String getDisplayScript();

    public String getDisplayScript(Locale var1);

    public final String getDisplayCountry();

    public String getDisplayCountry(@ReadOnly Locale this, Locale var1);

    private String getDisplayString(String var1, Locale var2, int var3);

    public final String getDisplayVariant();

    public String getDisplayVariant(@ReadOnly Locale this, Locale var1);

    public final String getDisplayName();

    public String getDisplayName(@ReadOnly Locale this, Locale var1);

    @SideEffectFree
    public @Immutable Object clone();

    @Pure
    public int hashCode();

    @Pure
    public boolean equals(@ReadOnly Locale this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    private String[] getDisplayVariantArray(Locale var1);

    private static String formatList(String[] var0, String var1, String var2);

    private static String[] composeList(MessageFormat var0, String[] var1);

    private static boolean isUnicodeExtensionKey(String var0);

    private void writeObject(ObjectOutputStream var1) throws IOException;

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    private Object readResolve() throws ObjectStreamException;

    private static String convertOldISOCodes(String var0);

    private static LocaleExtensions getCompatibilityExtensions(String var0, String var1, String var2, String var3);

    public static List<Locale> filter(List<LanguageRange> var0, Collection<Locale> var1, FilteringMode var2);

    public static List<Locale> filter(List<LanguageRange> var0, Collection<Locale> var1);

    public static List<String> filterTags(List<LanguageRange> var0, Collection<String> var1, FilteringMode var2);

    public static List<String> filterTags(List<LanguageRange> var0, Collection<String> var1);

    public static Locale lookup(List<LanguageRange> var0, Collection<Locale> var1);

    public static String lookupTag(List<LanguageRange> var0, Collection<String> var1);

    static;

    private static class Cache
    extends LocaleObjectCache<Object, Locale> {
        private static final Cache LOCALECACHE = new Cache();

        private Cache() {
        }

        @Override
        protected Locale createObject(Object key) {
            if (key instanceof BaseLocale) {
                return new Locale((BaseLocale)key, null);
            }
            LocaleKey lk = (LocaleKey)key;
            return new Locale(lk.base, lk.exts);
        }
    }

    private static final class LocaleKey {
        private final BaseLocale base;
        private final LocaleExtensions exts;
        private final int hash;

        private LocaleKey(BaseLocale baseLocale, LocaleExtensions extensions) {
            this.base = baseLocale;
            this.exts = extensions;
            int h = this.base.hashCode();
            if (this.exts != null) {
                h ^= this.exts.hashCode();
            }
            this.hash = h;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LocaleKey)) {
                return false;
            }
            LocaleKey other = (LocaleKey)obj;
            if (this.hash != other.hash || !this.base.equals(other.base)) {
                return false;
            }
            if (this.exts == null) {
                return other.exts == null;
            }
            return this.exts.equals(other.exts);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class LocaleNameGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<LocaleNameProvider, String> {
        private static final LocaleNameGetter INSTANCE = new LocaleNameGetter();

        private LocaleNameGetter() {
        }

        @Override
        public String getObject(LocaleNameProvider localeNameProvider, Locale locale, String key, Object ... params) {
            assert (params.length == 3);
            int type = (Integer)params[0];
            String code = (String)params[1];
            String cat = (String)params[2];
            switch (type) {
                case 0: {
                    return localeNameProvider.getDisplayLanguage(code, locale);
                }
                case 1: {
                    return localeNameProvider.getDisplayCountry(code, locale);
                }
                case 2: {
                    return localeNameProvider.getDisplayVariant(code, locale);
                }
                case 3: {
                    return localeNameProvider.getDisplayScript(code, locale);
                }
                case 4: {
                    return localeNameProvider.getDisplayUnicodeExtensionKey(code, locale);
                }
                case 5: {
                    return localeNameProvider.getDisplayUnicodeExtensionType(code, cat, locale);
                }
            }
            assert (false);
            return null;
        }
    }

    public static enum Category {
        DISPLAY("user.language.display", "user.script.display", "user.country.display", "user.variant.display", "user.extensions.display"),
        FORMAT("user.language.format", "user.script.format", "user.country.format", "user.variant.format", "user.extensions.format");

        final String languageKey;
        final String scriptKey;
        final String countryKey;
        final String variantKey;
        final String extensionsKey;

        private Category(String languageKey, String scriptKey, String countryKey, String variantKey, String extensionsKey) {
            this.languageKey = languageKey;
            this.scriptKey = scriptKey;
            this.countryKey = countryKey;
            this.variantKey = variantKey;
            this.extensionsKey = extensionsKey;
        }
    }

    public static final class Builder {
        private final InternalLocaleBuilder localeBuilder = new InternalLocaleBuilder();

        public Builder setLocale(Locale locale) {
            try {
                this.localeBuilder.setLocale(locale.baseLocale, locale.localeExtensions);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder setLanguageTag(String languageTag) {
            ParseStatus sts = new ParseStatus();
            LanguageTag tag = LanguageTag.parse(languageTag, sts);
            if (sts.isError()) {
                throw new IllformedLocaleException(sts.getErrorMessage(), sts.getErrorIndex());
            }
            this.localeBuilder.setLanguageTag(tag);
            return this;
        }

        public Builder setLanguage(String language) {
            try {
                this.localeBuilder.setLanguage(language);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder setScript(String script) {
            try {
                this.localeBuilder.setScript(script);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder setRegion(String region) {
            try {
                this.localeBuilder.setRegion(region);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder setVariant(String variant) {
            try {
                this.localeBuilder.setVariant(variant);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder setExtension(char key, String value) {
            try {
                this.localeBuilder.setExtension(key, value);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder setUnicodeLocaleKeyword(String key, String type) {
            try {
                this.localeBuilder.setUnicodeLocaleKeyword(key, type);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder addUnicodeLocaleAttribute(String attribute) {
            try {
                this.localeBuilder.addUnicodeLocaleAttribute(attribute);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder removeUnicodeLocaleAttribute(String attribute) {
            Objects.requireNonNull(attribute);
            try {
                this.localeBuilder.removeUnicodeLocaleAttribute(attribute);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder clear() {
            this.localeBuilder.clear();
            return this;
        }

        public Builder clearExtensions() {
            this.localeBuilder.clearExtensions();
            return this;
        }

        public Locale build() {
            BaseLocale baseloc = this.localeBuilder.getBaseLocale();
            LocaleExtensions extensions = this.localeBuilder.getLocaleExtensions();
            if (extensions == null && !baseloc.getVariant().isEmpty()) {
                extensions = Locale.getCompatibilityExtensions(baseloc.getLanguage(), baseloc.getScript(), baseloc.getRegion(), baseloc.getVariant());
            }
            return Locale.getInstance(baseloc, extensions);
        }
    }

    public static enum FilteringMode {
        AUTOSELECT_FILTERING,
        EXTENDED_FILTERING,
        IGNORE_EXTENDED_RANGES,
        MAP_EXTENDED_RANGES,
        REJECT_EXTENDED_RANGES;

    }

    public static final class LanguageRange {
        public static final double MAX_WEIGHT = 1.0;
        public static final double MIN_WEIGHT = 0.0;
        private final String range;
        private final double weight;
        @Stable
        private int hash;

        public LanguageRange(String range) {
            this(range, 1.0);
        }

        public LanguageRange(String range, double weight) {
            if (range == null) {
                throw new NullPointerException();
            }
            if (weight < 0.0 || weight > 1.0) {
                throw new IllegalArgumentException("weight=" + weight);
            }
            range = range.toLowerCase(ROOT);
            boolean isIllFormed = false;
            String[] subtags = range.split("-");
            if (LanguageRange.isSubtagIllFormed(subtags[0], true) || range.endsWith("-")) {
                isIllFormed = true;
            } else {
                for (int i = 1; i < subtags.length; ++i) {
                    if (!LanguageRange.isSubtagIllFormed(subtags[i], false)) continue;
                    isIllFormed = true;
                    break;
                }
            }
            if (isIllFormed) {
                throw new IllegalArgumentException("range=" + range);
            }
            this.range = range;
            this.weight = weight;
        }

        private static boolean isSubtagIllFormed(String subtag, boolean isFirstSubtag) {
            if (subtag.isEmpty() || subtag.length() > 8) {
                return true;
            }
            if (subtag.equals("*")) {
                return false;
            }
            char[] charArray = subtag.toCharArray();
            if (isFirstSubtag) {
                for (char c : charArray) {
                    if (c >= 'a' && c <= 'z') continue;
                    return true;
                }
            } else {
                for (char c : charArray) {
                    if (c >= '0' && (c <= '9' || c >= 'a') && c <= 'z') continue;
                    return true;
                }
            }
            return false;
        }

        public String getRange() {
            return this.range;
        }

        public double getWeight() {
            return this.weight;
        }

        public static List<LanguageRange> parse(String ranges) {
            return LocaleMatcher.parse(ranges);
        }

        public static List<LanguageRange> parse(String ranges, Map<String, List<String>> map) {
            return LanguageRange.mapEquivalents(LanguageRange.parse(ranges), map);
        }

        public static List<LanguageRange> mapEquivalents(List<LanguageRange> priorityList, Map<String, List<String>> map) {
            return LocaleMatcher.mapEquivalents(priorityList, map);
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                h = 17;
                h = 37 * h + this.range.hashCode();
                long bitsWeight = Double.doubleToLongBits(this.weight);
                if ((h = 37 * h + (int)(bitsWeight ^ bitsWeight >>> 32)) != 0) {
                    this.hash = h;
                }
            }
            return h;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LanguageRange)) return false;
            LanguageRange other = (LanguageRange)obj;
            if (!this.range.equals(other.range)) return false;
            if (this.weight != other.weight) return false;
            return true;
        }

        public String toString() {
            return this.weight == 1.0 ? this.range : this.range + ";q=" + this.weight;
        }
    }
}

