/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;

class SubList<E>
extends AbstractList<E> {
    private final AbstractList<E> l;
    private final int offset;
    private int size;

    @PolyRead SubList(@PolyRead AbstractList<E> abstractList, int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > abstractList.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        this.l = abstractList;
        this.offset = n;
        this.size = n2 - n;
        this.modCount = this.l.modCount;
    }

    @Override
    public E set(int n, E e) {
        this.rangeCheck(n);
        this.checkForComodification();
        return this.l.set(n + this.offset, e);
    }

    @Override
    public E get(@ReadOnly SubList<E> this, int n) {
        this.rangeCheck(n);
        this.checkForComodification();
        return this.l.get(n + this.offset);
    }

    @Override
    public int size(@ReadOnly SubList<E> this) {
        this.checkForComodification();
        return this.size;
    }

    @Override
    public void add(int n, E e) {
        this.rangeCheckForAdd(n);
        this.checkForComodification();
        this.l.add(n + this.offset, e);
        this.modCount = this.l.modCount;
        ++this.size;
    }

    @Override
    public E remove(int n) {
        this.rangeCheck(n);
        this.checkForComodification();
        E e = this.l.remove(n + this.offset);
        this.modCount = this.l.modCount;
        --this.size;
        return e;
    }

    @Override
    protected void removeRange(int n, int n2) {
        this.checkForComodification();
        this.l.removeRange(n + this.offset, n2 + this.offset);
        this.modCount = this.l.modCount;
        this.size -= n2 - n;
    }

    @Override
    public boolean addAll(@ReadOnly Collection<? extends E> collection) {
        return this.addAll(this.size, collection);
    }

    @Override
    public boolean addAll(int n, @ReadOnly Collection<? extends E> collection) {
        this.rangeCheckForAdd(n);
        int n2 = collection.size();
        if (n2 == 0) {
            return false;
        }
        this.checkForComodification();
        this.l.addAll(this.offset + n, collection);
        this.modCount = this.l.modCount;
        this.size += n2;
        return true;
    }

    @Override
    public @PolyRead Iterator<E> iterator(@PolyRead SubList<E> this) {
        return this.listIterator();
    }

    @Override
    public @PolyRead ListIterator<E> listIterator(@PolyRead SubList<E> this, int n) {
        this.checkForComodification();
        this.rangeCheckForAdd(n);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public @PolyRead List<E> subList(@PolyRead SubList<E> this, int n, int n2) {
        return new SubList<E>(this, n, n2);
    }

    private void rangeCheck(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    private void rangeCheckForAdd(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    private String outOfBoundsMsg(int n) {
        return "Index: " + n + ", Size: " + this.size;
    }

    private void checkForComodification() {
        if (this.modCount != this.l.modCount) {
            throw new ConcurrentModificationException();
        }
    }

    static /* synthetic */ int access$000(SubList subList) {
        return subList.offset;
    }

    static /* synthetic */ AbstractList access$100(SubList subList) {
        return subList.l;
    }

    static /* synthetic */ int access$200(SubList subList) {
        return subList.size;
    }

    static /* synthetic */ int access$210(SubList subList) {
        return subList.size--;
    }

    static /* synthetic */ int access$208(SubList subList) {
        return subList.size++;
    }
}

