/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SequencedCollection;
import java.util.SequencedSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

@I
public class LinkedHashMap<K, V>
extends HashMap<K, V>
implements Map<K, V> {
    private static final long serialVersionUID = 3801124242820219131L;
    transient Entry<K, V> head;
    transient Entry<K, V> tail;
    final boolean accessOrder;

    private void linkNodeLast(Entry<K, V> entry) {
        Entry<K, V> entry2 = this.tail;
        this.tail = entry;
        if (entry2 == null) {
            this.head = entry;
        } else {
            entry.before = entry2;
            entry2.after = entry;
        }
    }

    private void transferLinks(Entry<K, V> entry, Entry<K, V> entry2) {
        Entry entry3 = entry2.before = entry.before;
        Entry entry4 = entry2.after = entry.after;
        if (entry3 == null) {
            this.head = entry2;
        } else {
            entry3.after = entry2;
        }
        if (entry4 == null) {
            this.tail = entry2;
        } else {
            entry4.before = entry2;
        }
    }

    @Override
    void reinitialize() {
        super.reinitialize();
        this.tail = null;
        this.head = null;
    }

    @Override
    HashMap.Node<K, V> newNode(int n, K k, V v, HashMap.Node<K, V> node) {
        Entry<K, V> entry = new Entry<K, V>(n, k, v, node);
        this.linkNodeLast(entry);
        return entry;
    }

    @Override
    HashMap.Node<K, V> replacementNode(HashMap.Node<K, V> node, HashMap.Node<K, V> node2) {
        Entry entry = (Entry)node;
        Entry<Object, Object> entry2 = new Entry<Object, Object>(entry.hash, entry.key, entry.value, node2);
        this.transferLinks(entry, entry2);
        return entry2;
    }

    @Override
    HashMap.TreeNode<K, V> newTreeNode(int n, K k, V v, HashMap.Node<K, V> node) {
        HashMap.TreeNode<K, V> treeNode = new HashMap.TreeNode<K, V>(n, k, v, node);
        this.linkNodeLast(treeNode);
        return treeNode;
    }

    @Override
    HashMap.TreeNode<K, V> replacementTreeNode(HashMap.Node<K, V> node, HashMap.Node<K, V> node2) {
        Entry entry = (Entry)node;
        HashMap.TreeNode<Object, Object> treeNode = new HashMap.TreeNode<Object, Object>(entry.hash, entry.key, entry.value, node2);
        this.transferLinks(entry, treeNode);
        return treeNode;
    }

    @Override
    void afterNodeRemoval(HashMap.Node<K, V> node) {
        Entry entry = (Entry)node;
        Entry entry2 = entry.before;
        Entry entry3 = entry.after;
        entry.after = null;
        entry.before = null;
        if (entry2 == null) {
            this.head = entry3;
        } else {
            entry2.after = entry3;
        }
        if (entry3 == null) {
            this.tail = entry2;
        } else {
            entry3.before = entry2;
        }
    }

    @Override
    void afterNodeInsertion(boolean bl) {
        Entry<K, V> entry;
        if (bl && (entry = this.head) != null && this.removeEldestEntry(entry)) {
            Object object = entry.key;
            this.removeNode(LinkedHashMap.hash(object), object, null, false, true);
        }
    }

    @Override
    void afterNodeAccess(HashMap.Node<K, V> node) {
        Entry<K, V> entry;
        if (this.accessOrder && (entry = this.tail) != node) {
            Entry entry2 = (Entry)node;
            Entry entry3 = entry2.before;
            Entry entry4 = entry2.after;
            entry2.after = null;
            if (entry3 == null) {
                this.head = entry4;
            } else {
                entry3.after = entry4;
            }
            if (entry4 != null) {
                entry4.before = entry3;
            } else {
                entry = entry3;
            }
            if (entry == null) {
                this.head = entry2;
            } else {
                entry2.before = entry;
                entry.after = entry2;
            }
            this.tail = entry2;
            ++this.modCount;
        }
    }

    @Override
    void internalWriteEntries(ObjectOutputStream objectOutputStream) throws IOException {
        Entry<K, V> entry = this.head;
        while (entry != null) {
            objectOutputStream.writeObject(entry.key);
            objectOutputStream.writeObject(entry.value);
            entry = entry.after;
        }
    }

    public LinkedHashMap(int n, float f) {
        super(n, f);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n) {
        super(n);
        this.accessOrder = false;
    }

    public LinkedHashMap() {
        this.accessOrder = false;
    }

    public LinkedHashMap(@org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Map<? extends K, ? extends V> map) {
        this.accessOrder = false;
        this.putMapEntries(map, false);
    }

    public LinkedHashMap(int n, float f, boolean bl) {
        super(n, f);
        this.accessOrder = bl;
    }

    @Override
    @Pure
    public boolean containsValue(@org.checkerframework.checker.igj.qual.ReadOnly LinkedHashMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        Entry<K, V> entry = this.head;
        while (entry != null) {
            Object object2 = entry.value;
            if (object2 == object || object != null && object.equals(object2)) {
                return true;
            }
            entry = entry.after;
        }
        return false;
    }

    @Override
    @Pure
    public @Nullable V get(@org.checkerframework.checker.igj.qual.ReadOnly LinkedHashMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        HashMap.Node node = this.getNode(LinkedHashMap.hash(object), object);
        if (node == null) {
            return null;
        }
        if (this.accessOrder) {
            this.afterNodeAccess(node);
        }
        return node.value;
    }

    @Override
    public V getOrDefault(Object object, V v) {
        HashMap.Node node = this.getNode(LinkedHashMap.hash(object), object);
        if (node == null) {
            return v;
        }
        if (this.accessOrder) {
            this.afterNodeAccess(node);
        }
        return node.value;
    }

    @Override
    public void clear(@Mutable LinkedHashMap<K, V> this) {
        super.clear();
        this.tail = null;
        this.head = null;
    }

    protected boolean removeEldestEntry(@ReadOnly Map.Entry<K, V> entry) {
        return false;
    }

    @Override
    public Set<K> keySet() {
        Set set = this.keySet;
        return set == null ? (this.keySet = new LinkedKeySet(this)) : set;
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        return collection == null ? (this.values = new LinkedValues(this)) : collection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set set = this.entrySet;
        return set == null ? (this.entrySet = new LinkedEntrySet(this)) : set;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        if (biConsumer == null) {
            throw new NullPointerException();
        }
        int n = this.modCount;
        Entry<K, V> entry = this.head;
        while (entry != null) {
            biConsumer.accept(entry.key, entry.value);
            entry = entry.after;
        }
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        if (biFunction == null) {
            throw new NullPointerException();
        }
        int n = this.modCount;
        Entry<K, V> entry = this.head;
        while (entry != null) {
            entry.value = biFunction.apply(entry.key, entry.value);
            entry = entry.after;
        }
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
    }

    static class Entry<K, V>
    extends HashMap.Node<K, V> {
        Entry<K, V> before;
        Entry<K, V> after;

        Entry(int hash, K key, V value, HashMap.Node<K, V> next) {
            super(hash, key, value, next);
        }
    }

    final class LinkedEntryIterator
    extends LinkedHashIterator
    implements Iterator<Map.Entry<K, V>> {
        LinkedEntryIterator(LinkedHashMap this$0, boolean reversed) {
            super(reversed);
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.nextNode();
        }
    }

    final class LinkedEntrySet
    extends AbstractSet<Map.Entry<K, V>>
    implements SequencedSet<Map.Entry<K, V>> {
        final boolean reversed;

        LinkedEntrySet(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public final int size() {
            return LinkedHashMap.this.size;
        }

        @Override
        public final void clear() {
            LinkedHashMap.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new LinkedEntryIterator(LinkedHashMap.this, this.reversed);
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            HashMap.Node candidate = LinkedHashMap.this.getNode(key);
            return candidate != null && candidate.equals(e);
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return LinkedHashMap.this.removeNode(HashMap.hash(key), key, value, true, true) != null;
            }
            return false;
        }

        @Override
        public final Spliterator<Map.Entry<K, V>> spliterator() {
            return Spliterators.spliterator(this, 81);
        }

        @Override
        public final void forEach(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = LinkedHashMap.this.modCount;
            if (this.reversed) {
                Entry e = LinkedHashMap.this.tail;
                while (e != null) {
                    action.accept(e);
                    e = e.before;
                }
            } else {
                Entry e = LinkedHashMap.this.head;
                while (e != null) {
                    action.accept(e);
                    e = e.after;
                }
            }
            if (LinkedHashMap.this.modCount != mc) {
                throw new ConcurrentModificationException();
            }
        }

        final HashMap.Node<K, V> nsee(HashMap.Node<K, V> e) {
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e;
        }

        @Override
        public final void addFirst(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void addLast(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Map.Entry<K, V> getFirst() {
            return this.nsee(this.reversed ? LinkedHashMap.this.tail : LinkedHashMap.this.head);
        }

        @Override
        public final Map.Entry<K, V> getLast() {
            return this.nsee(this.reversed ? LinkedHashMap.this.head : LinkedHashMap.this.tail);
        }

        @Override
        public final Map.Entry<K, V> removeFirst() {
            HashMap.Node node = this.nsee(this.reversed ? LinkedHashMap.this.tail : LinkedHashMap.this.head);
            LinkedHashMap.this.removeNode(node.hash, node.key, null, false, false);
            return node;
        }

        @Override
        public final Map.Entry<K, V> removeLast() {
            HashMap.Node node = this.nsee(this.reversed ? LinkedHashMap.this.head : LinkedHashMap.this.tail);
            LinkedHashMap.this.removeNode(node.hash, node.key, null, false, false);
            return node;
        }

        @Override
        public SequencedSet<Map.Entry<K, V>> reversed() {
            if (this.reversed) {
                return LinkedHashMap.this.sequencedEntrySet();
            }
            return new LinkedEntrySet(true);
        }
    }

    abstract class LinkedHashIterator {
        Entry<K, V> next;
        Entry<K, V> current;
        int expectedModCount;
        boolean reversed;

        LinkedHashIterator(boolean reversed) {
            this.reversed = reversed;
            this.next = reversed ? LinkedHashMap.this.tail : LinkedHashMap.this.head;
            this.expectedModCount = LinkedHashMap.this.modCount;
            this.current = null;
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextNode() {
            Entry e = this.next;
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.current = e;
            this.next = this.reversed ? e.before : e.after;
            return e;
        }

        public final void remove() {
            Entry p = this.current;
            if (p == null) {
                throw new IllegalStateException();
            }
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.current = null;
            LinkedHashMap.this.removeNode(p.hash, p.key, null, false, false);
            this.expectedModCount = LinkedHashMap.this.modCount;
        }
    }

    final class LinkedKeyIterator
    extends LinkedHashIterator
    implements Iterator<K> {
        LinkedKeyIterator(LinkedHashMap this$0, boolean reversed) {
            super(reversed);
        }

        @Override
        public final K next() {
            return this.nextNode().getKey();
        }
    }

    final class LinkedKeySet
    extends AbstractSet<K>
    implements SequencedSet<K> {
        final boolean reversed;

        LinkedKeySet(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public final int size() {
            return LinkedHashMap.this.size;
        }

        @Override
        public final void clear() {
            LinkedHashMap.this.clear();
        }

        @Override
        public final Iterator<K> iterator() {
            return new LinkedKeyIterator(LinkedHashMap.this, this.reversed);
        }

        @Override
        public final boolean contains(Object o) {
            return LinkedHashMap.this.containsKey(o);
        }

        @Override
        public final boolean remove(Object key) {
            return LinkedHashMap.this.removeNode(HashMap.hash(key), key, null, false, true) != null;
        }

        @Override
        public final Spliterator<K> spliterator() {
            return Spliterators.spliterator(this, 81);
        }

        @Override
        public Object[] toArray() {
            return LinkedHashMap.this.keysToArray(new Object[LinkedHashMap.this.size], this.reversed);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return LinkedHashMap.this.keysToArray(LinkedHashMap.this.prepareArray(a), this.reversed);
        }

        @Override
        public final void forEach(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = LinkedHashMap.this.modCount;
            if (this.reversed) {
                Entry e = LinkedHashMap.this.tail;
                while (e != null) {
                    action.accept(e.key);
                    e = e.before;
                }
            } else {
                Entry e = LinkedHashMap.this.head;
                while (e != null) {
                    action.accept(e.key);
                    e = e.after;
                }
            }
            if (LinkedHashMap.this.modCount != mc) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public final void addFirst(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void addLast(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final K getFirst() {
            return LinkedHashMap.nsee(this.reversed ? LinkedHashMap.this.tail : LinkedHashMap.this.head).key;
        }

        @Override
        public final K getLast() {
            return LinkedHashMap.nsee(this.reversed ? LinkedHashMap.this.head : LinkedHashMap.this.tail).key;
        }

        @Override
        public final K removeFirst() {
            HashMap.Node node = LinkedHashMap.nsee(this.reversed ? LinkedHashMap.this.tail : LinkedHashMap.this.head);
            LinkedHashMap.this.removeNode(node.hash, node.key, null, false, false);
            return node.key;
        }

        @Override
        public final K removeLast() {
            HashMap.Node node = LinkedHashMap.nsee(this.reversed ? LinkedHashMap.this.head : LinkedHashMap.this.tail);
            LinkedHashMap.this.removeNode(node.hash, node.key, null, false, false);
            return node.key;
        }

        @Override
        public SequencedSet<K> reversed() {
            if (this.reversed) {
                return LinkedHashMap.this.sequencedKeySet();
            }
            return new LinkedKeySet(true);
        }
    }

    final class LinkedValueIterator
    extends LinkedHashIterator
    implements Iterator<V> {
        LinkedValueIterator(LinkedHashMap this$0, boolean reversed) {
            super(reversed);
        }

        @Override
        public final V next() {
            return this.nextNode().value;
        }
    }

    final class LinkedValues
    extends AbstractCollection<V>
    implements SequencedCollection<V> {
        final boolean reversed;

        LinkedValues(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public final int size() {
            return LinkedHashMap.this.size;
        }

        @Override
        public final void clear() {
            LinkedHashMap.this.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            return new LinkedValueIterator(LinkedHashMap.this, this.reversed);
        }

        @Override
        public final boolean contains(Object o) {
            return LinkedHashMap.this.containsValue(o);
        }

        @Override
        public final Spliterator<V> spliterator() {
            return Spliterators.spliterator(this, 80);
        }

        @Override
        public Object[] toArray() {
            return LinkedHashMap.this.valuesToArray(new Object[LinkedHashMap.this.size], this.reversed);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return LinkedHashMap.this.valuesToArray(LinkedHashMap.this.prepareArray(a), this.reversed);
        }

        @Override
        public final void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = LinkedHashMap.this.modCount;
            if (this.reversed) {
                Entry e = LinkedHashMap.this.tail;
                while (e != null) {
                    action.accept(e.value);
                    e = e.before;
                }
            } else {
                Entry e = LinkedHashMap.this.head;
                while (e != null) {
                    action.accept(e.value);
                    e = e.after;
                }
            }
            if (LinkedHashMap.this.modCount != mc) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public final void addFirst(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void addLast(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final V getFirst() {
            return LinkedHashMap.nsee(this.reversed ? LinkedHashMap.this.tail : LinkedHashMap.this.head).value;
        }

        @Override
        public final V getLast() {
            return LinkedHashMap.nsee(this.reversed ? LinkedHashMap.this.head : LinkedHashMap.this.tail).value;
        }

        @Override
        public final V removeFirst() {
            HashMap.Node node = LinkedHashMap.nsee(this.reversed ? LinkedHashMap.this.tail : LinkedHashMap.this.head);
            LinkedHashMap.this.removeNode(node.hash, node.key, null, false, false);
            return node.value;
        }

        @Override
        public final V removeLast() {
            HashMap.Node node = LinkedHashMap.nsee(this.reversed ? LinkedHashMap.this.head : LinkedHashMap.this.tail);
            LinkedHashMap.this.removeNode(node.hash, node.key, null, false, false);
            return node.value;
        }

        @Override
        public SequencedCollection<V> reversed() {
            if (this.reversed) {
                return LinkedHashMap.this.sequencedValues();
            }
            return new LinkedValues(true);
        }
    }
}

