/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UTFDataFormatException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class DataInputStream
extends FilterInputStream
implements DataInput {
    private byte[] bytearr = new byte[80];
    private char[] chararr = new char[80];
    private byte[] readBuffer = new byte[8];
    private char[] lineBuffer;

    public DataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public final int read(byte[] byArray) throws IOException {
        return this.in.read(byArray, 0, byArray.length);
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n2; i += n3) {
            n3 = this.in.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n && (n3 = (int)this.in.skip(n - n2)) > 0; n2 += n3) {
        }
        return n2;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public final short readShort() throws IOException {
        int n;
        int n2 = this.in.read();
        if ((n2 | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.in.read();
        if ((n2 | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    @Override
    public final char readChar() throws IOException {
        int n;
        int n2 = this.in.read();
        if ((n2 | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    @Override
    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.in.read();
        if ((n4 | (n3 = this.in.read()) | (n2 = this.in.read()) | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    @Override
    public final long readLong() throws IOException {
        this.readFully(this.readBuffer, 0, 8);
        return ((long)this.readBuffer[0] << 56) + ((long)(this.readBuffer[1] & 0xFF) << 48) + ((long)(this.readBuffer[2] & 0xFF) << 40) + ((long)(this.readBuffer[3] & 0xFF) << 32) + ((long)(this.readBuffer[4] & 0xFF) << 24) + (long)((this.readBuffer[5] & 0xFF) << 16) + (long)((this.readBuffer[6] & 0xFF) << 8) + (long)((this.readBuffer[7] & 0xFF) << 0);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    @Deprecated
    @Deprecated
    public final @Nullable String readLine() throws IOException {
        int n;
        char[] cArray = this.lineBuffer;
        if (cArray == null) {
            cArray = this.lineBuffer = new char[128];
        }
        int n2 = cArray.length;
        int n3 = 0;
        block4: while (true) {
            n = this.in.read();
            switch (n) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int n4 = this.in.read();
                    if (n4 == 10 || n4 == -1) break block4;
                    if (!(this.in instanceof PushbackInputStream)) {
                        this.in = new PushbackInputStream(this.in);
                    }
                    ((PushbackInputStream)this.in).unread(n4);
                    break block4;
                }
                default: {
                    if (--n2 < 0) {
                        cArray = new char[n3 + 128];
                        n2 = cArray.length - n3 - 1;
                        System.arraycopy(this.lineBuffer, 0, cArray, 0, n3);
                        this.lineBuffer = cArray;
                    }
                    cArray[n3++] = (char)n;
                    continue block4;
                }
            }
            break;
        }
        if (n == -1 && n3 == 0) {
            return null;
        }
        return String.copyValueOf(cArray, 0, n3);
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public static final String readUTF(DataInput dataInput) throws IOException {
        int n;
        int n2;
        int n3 = dataInput.readUnsignedShort();
        byte[] byArray = null;
        char[] cArray = null;
        if (dataInput instanceof DataInputStream) {
            DataInputStream dataInputStream = (DataInputStream)dataInput;
            if (dataInputStream.bytearr.length < n3) {
                dataInputStream.bytearr = new byte[n3 * 2];
                dataInputStream.chararr = new char[n3 * 2];
            }
            cArray = dataInputStream.chararr;
            byArray = dataInputStream.bytearr;
        } else {
            byArray = new byte[n3];
            cArray = new char[n3];
        }
        int n4 = 0;
        dataInput.readFully(byArray, 0, n3);
        for (n2 = 0; n2 < n3 && (n = byArray[n2] & 0xFF) <= 127; ++n2) {
            cArray[n4++] = (char)n;
        }
        block6: while (n2 < n3) {
            int n5 = byArray[n2] & 0xFF;
            switch (n5 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    cArray[n4++] = (char)n5;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n3) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte by = byArray[n2 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + n2);
                    }
                    cArray[n4++] = (char)((n5 & 0x1F) << 6 | by & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((n2 += 3) > n3) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte by = byArray[n2 - 2];
                    byte by2 = byArray[n2 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (n2 - 1));
                    }
                    cArray[n4++] = (char)((n5 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + n2);
        }
        return new String(cArray, 0, n4);
    }
}

