/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@I
public class LinkedList<E>
extends AbstractSequentialList<E>
implements List<E>,
Deque<E>,
Cloneable,
Serializable {
    transient int size = 0;
    transient Node<E> first;
    transient Node<E> last;
    private static final long serialVersionUID = 876323262645176354L;

    public LinkedList() {
    }

    public @PolyRead LinkedList(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    private void linkFirst(E e) {
        Node<E> node = this.first;
        Node<E> node2 = new Node<E>(null, e, node);
        this.first = node2;
        if (node == null) {
            this.last = node2;
        } else {
            node.prev = node2;
        }
        ++this.size;
        ++this.modCount;
    }

    void linkLast(E e) {
        Node<E> node = this.last;
        Node<E> node2 = new Node<E>(node, e, null);
        this.last = node2;
        if (node == null) {
            this.first = node2;
        } else {
            node.next = node2;
        }
        ++this.size;
        ++this.modCount;
    }

    void linkBefore(E e, Node<E> node) {
        Node node2 = node.prev;
        Node node3 = new Node(node2, e, node);
        node.prev = node3;
        if (node2 == null) {
            this.first = node3;
        } else {
            node2.next = node3;
        }
        ++this.size;
        ++this.modCount;
    }

    private E unlinkFirst(Node<E> node) {
        Object e = node.item;
        Node node2 = node.next;
        node.item = null;
        node.next = null;
        this.first = node2;
        if (node2 == null) {
            this.last = null;
        } else {
            node2.prev = null;
        }
        --this.size;
        ++this.modCount;
        return e;
    }

    private E unlinkLast(Node<E> node) {
        Object e = node.item;
        Node node2 = node.prev;
        node.item = null;
        node.prev = null;
        this.last = node2;
        if (node2 == null) {
            this.first = null;
        } else {
            node2.next = null;
        }
        --this.size;
        ++this.modCount;
        return e;
    }

    E unlink(Node<E> node) {
        Object e = node.item;
        Node node2 = node.next;
        Node node3 = node.prev;
        if (node3 == null) {
            this.first = node2;
        } else {
            node3.next = node2;
            node.prev = null;
        }
        if (node2 == null) {
            this.last = node3;
        } else {
            node2.prev = node3;
            node.next = null;
        }
        node.item = null;
        --this.size;
        ++this.modCount;
        return e;
    }

    @Override
    public E getFirst(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this) {
        Node<E> node = this.first;
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.item;
    }

    @Override
    public E getLast(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this) {
        Node<E> node = this.last;
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.item;
    }

    @Override
    public E removeFirst(@Mutable LinkedList<E> this) {
        Node<E> node = this.first;
        if (node == null) {
            throw new NoSuchElementException();
        }
        return this.unlinkFirst(node);
    }

    @Override
    public E removeLast(@Mutable LinkedList<E> this) {
        Node<E> node = this.last;
        if (node == null) {
            throw new NoSuchElementException();
        }
        return this.unlinkLast(node);
    }

    @Override
    public void addFirst(@Mutable LinkedList<E> this, E e) {
        this.linkFirst(e);
    }

    @Override
    public void addLast(@Mutable LinkedList<E> this, E e) {
        this.linkLast(e);
    }

    @Override
    @Pure
    public boolean contains(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    @Pure
    public int size(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this) {
        return this.size;
    }

    @Override
    public boolean add(@Mutable LinkedList<E> this, E e) {
        this.linkLast(e);
        return true;
    }

    @Override
    public boolean remove(@Mutable LinkedList<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        if (object == null) {
            Node<E> node = this.first;
            while (node != null) {
                if (node.item == null) {
                    this.unlink(node);
                    return true;
                }
                node = node.next;
            }
        } else {
            Node<E> node = this.first;
            while (node != null) {
                if (object.equals(node.item)) {
                    this.unlink(node);
                    return true;
                }
                node = node.next;
            }
        }
        return false;
    }

    @Override
    public boolean addAll(@Mutable LinkedList<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> collection) {
        return this.addAll(this.size, collection);
    }

    @Override
    public boolean addAll(@Mutable LinkedList<E> this, int n, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> collection) {
        Node<Object> node;
        Node<E> node2;
        this.checkPositionIndex(n);
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        if (n2 == 0) {
            return false;
        }
        if (n == this.size) {
            node2 = null;
            node = this.last;
        } else {
            node2 = this.node(n);
            node = node2.prev;
        }
        Object[] objectArray2 = objectArray;
        int n3 = objectArray2.length;
        for (int i = 0; i < n3; ++i) {
            Object object;
            Object object2 = object = objectArray2[i];
            Node<Object> node3 = new Node<Object>(node, object2, null);
            if (node == null) {
                this.first = node3;
            } else {
                node.next = node3;
            }
            node = node3;
        }
        if (node2 == null) {
            this.last = node;
        } else {
            node.next = node2;
            node2.prev = node;
        }
        this.size += n2;
        ++this.modCount;
        return true;
    }

    @Override
    public void clear(@Mutable LinkedList<E> this) {
        Node<E> node = this.first;
        while (node != null) {
            Node node2 = node.next;
            node.item = null;
            node.next = null;
            node.prev = null;
            node = node2;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
        ++this.modCount;
    }

    @Override
    @Pure
    public E get(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, int n) {
        this.checkElementIndex(n);
        return this.node((int)n).item;
    }

    @Override
    public E set(@Mutable LinkedList<E> this, int n, E e) {
        this.checkElementIndex(n);
        Node<E> node = this.node(n);
        Object e2 = node.item;
        node.item = e;
        return e2;
    }

    @Override
    public void add(@Mutable LinkedList<E> this, int n, E e) {
        this.checkPositionIndex(n);
        if (n == this.size) {
            this.linkLast(e);
        } else {
            this.linkBefore(e, this.node(n));
        }
    }

    @Override
    public E remove(@Mutable LinkedList<E> this, int n) {
        this.checkElementIndex(n);
        return this.unlink(this.node(n));
    }

    private boolean isElementIndex(int n) {
        return n >= 0 && n < this.size;
    }

    private boolean isPositionIndex(int n) {
        return n >= 0 && n <= this.size;
    }

    private String outOfBoundsMsg(int n) {
        return "Index: " + n + ", Size: " + this.size;
    }

    private void checkElementIndex(int n) {
        if (!this.isElementIndex(n)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    private void checkPositionIndex(int n) {
        if (!this.isPositionIndex(n)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    Node<E> node(int n) {
        if (n < this.size >> 1) {
            Node<E> node = this.first;
            for (int i = 0; i < n; ++i) {
                node = node.next;
            }
            return node;
        }
        Node<E> node = this.last;
        for (int i = this.size - 1; i > n; --i) {
            node = node.prev;
        }
        return node;
    }

    @Override
    @Pure
    public int indexOf(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        int n = 0;
        if (object == null) {
            Node<E> node = this.first;
            while (node != null) {
                if (node.item == null) {
                    return n;
                }
                ++n;
                node = node.next;
            }
        } else {
            Node<E> node = this.first;
            while (node != null) {
                if (object.equals(node.item)) {
                    return n;
                }
                ++n;
                node = node.next;
            }
        }
        return -1;
    }

    @Override
    @Pure
    public int lastIndexOf(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        int n = this.size;
        if (object == null) {
            Node<E> node = this.last;
            while (node != null) {
                --n;
                if (node.item == null) {
                    return n;
                }
                node = node.prev;
            }
        } else {
            Node<E> node = this.last;
            while (node != null) {
                --n;
                if (object.equals(node.item)) {
                    return n;
                }
                node = node.prev;
            }
        }
        return -1;
    }

    @Override
    public @Nullable E peek(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this) {
        Node<E> node = this.first;
        return node == null ? null : (E)node.item;
    }

    @Override
    public E element(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this) {
        return this.getFirst();
    }

    @Override
    public @Nullable E poll(@Mutable LinkedList<E> this) {
        Node<E> node = this.first;
        return node == null ? null : (E)this.unlinkFirst(node);
    }

    @Override
    public E remove(@Mutable LinkedList<E> this) {
        return this.removeFirst();
    }

    @Override
    public boolean offer(@Mutable LinkedList<E> this, E e) {
        return this.add(e);
    }

    @Override
    public boolean offerFirst(@Mutable LinkedList<E> this, E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(@Mutable LinkedList<E> this, E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public @Nullable E peekFirst(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this) {
        Node<E> node = this.first;
        return node == null ? null : (E)node.item;
    }

    @Override
    public @Nullable E peekLast(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this) {
        Node<E> node = this.last;
        return node == null ? null : (E)node.item;
    }

    @Override
    public @Nullable E pollFirst(@Mutable LinkedList<E> this) {
        Node<E> node = this.first;
        return node == null ? null : (E)this.unlinkFirst(node);
    }

    @Override
    public @Nullable E pollLast(@Mutable LinkedList<E> this) {
        Node<E> node = this.last;
        return node == null ? null : (E)this.unlinkLast(node);
    }

    @Override
    public void push(@Mutable LinkedList<E> this, E e) {
        this.addFirst(e);
    }

    @Override
    public E pop(@Mutable LinkedList<E> this) {
        return this.removeFirst();
    }

    @Override
    public boolean removeFirstOccurrence(@Mutable LinkedList<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        return this.remove(object);
    }

    @Override
    public boolean removeLastOccurrence(@Mutable LinkedList<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        if (object == null) {
            Node<E> node = this.last;
            while (node != null) {
                if (node.item == null) {
                    this.unlink(node);
                    return true;
                }
                node = node.prev;
            }
        } else {
            Node<E> node = this.last;
            while (node != null) {
                if (object.equals(node.item)) {
                    this.unlink(node);
                    return true;
                }
                node = node.prev;
            }
        }
        return false;
    }

    @Override
    public @I @PolyRead ListIterator<E> listIterator(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, int n) {
        this.checkPositionIndex(n);
        return new ListItr(n);
    }

    @Override
    public @I @PolyRead Iterator<E> descendingIterator(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this) {
        return new DescendingIterator(this, null);
    }

    private LinkedList<E> superClone() {
        try {
            return (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    @SideEffectFree
    public @I(value="N") Object clone() {
        LinkedList linkedList = this.superClone();
        linkedList.last = null;
        linkedList.first = null;
        linkedList.size = 0;
        linkedList.modCount = 0;
        Node<E> node = this.first;
        while (node != null) {
            linkedList.add(node.item);
            node = node.next;
        }
        return linkedList;
    }

    @Override
    public @Nullable Object[] toArray(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this) {
        Object[] objectArray = new Object[this.size];
        int n = 0;
        Node<E> node = this.first;
        while (node != null) {
            objectArray[n++] = node.item;
            node = node.next;
        }
        return objectArray;
    }

    @Override
    public <T> @Nullable T @PolyNull [] toArray(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, T @PolyNull [] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        int n = 0;
        T[] TArray = objectArray;
        Node<E> node = this.first;
        while (node != null) {
            TArray[n++] = node.item;
            node = node.next;
        }
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Node<E> node = this.first;
        while (node != null) {
            objectOutputStream.writeObject(node.item);
            node = node.next;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.linkLast(objectInputStream.readObject());
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return new LLSpliterator(this, -1, 0);
    }

    private class DescendingIterator
    implements Iterator<E> {
        private final ListItr itr;

        private DescendingIterator() {
            this.itr = new ListItr(LinkedList.this.size());
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            return this.itr.previous();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    static final class LLSpliterator<E>
    implements Spliterator<E> {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        final LinkedList<E> list;
        Node<E> current;
        int est;
        int expectedModCount;
        int batch;

        LLSpliterator(LinkedList<E> list, int est, int expectedModCount) {
            this.list = list;
            this.est = est;
            this.expectedModCount = expectedModCount;
        }

        final int getEst() {
            int s = this.est;
            if (s < 0) {
                LinkedList<E> lst = this.list;
                if (lst == null) {
                    this.est = 0;
                    s = 0;
                } else {
                    this.expectedModCount = lst.modCount;
                    this.current = lst.first;
                    s = this.est = lst.size;
                }
            }
            return s;
        }

        @Override
        public long estimateSize() {
            return this.getEst();
        }

        @Override
        public Spliterator<E> trySplit() {
            Node<E> p;
            int s = this.getEst();
            if (s > 1 && (p = this.current) != null) {
                int n = this.batch + 1024;
                if (n > s) {
                    n = s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                Object[] a = new Object[n];
                int j = 0;
                do {
                    a[j++] = p.item;
                } while ((p = p.next) != null && j < n);
                this.current = p;
                this.batch = j;
                this.est = s - j;
                return Spliterators.spliterator(a, 0, j, 16);
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Node<E> p;
            if (action == null) {
                throw new NullPointerException();
            }
            int n = this.getEst();
            if (n > 0 && (p = this.current) != null) {
                this.current = null;
                this.est = 0;
                do {
                    Object e = p.item;
                    p = p.next;
                    action.accept(e);
                } while (p != null && --n > 0);
            }
            if (this.list.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            Node<E> p;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.getEst() > 0 && (p = this.current) != null) {
                --this.est;
                Object e = p.item;
                this.current = p.next;
                action.accept(e);
                if (this.list.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }

    private class ListItr
    implements ListIterator<E> {
        private Node<E> lastReturned;
        private Node<E> next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int index) {
            this.expectedModCount = LinkedList.this.modCount;
            this.next = index == LinkedList.this.size ? null : LinkedList.this.node(index);
            this.nextIndex = index;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < LinkedList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.next = this.next == null ? LinkedList.this.last : this.next.prev;
            this.lastReturned = this.next;
            --this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            Node lastNext = this.lastReturned.next;
            LinkedList.this.unlink(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = lastNext;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = null;
            ++this.expectedModCount;
        }

        @Override
        public void set(E e) {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.item = e;
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            this.lastReturned = null;
            if (this.next == null) {
                LinkedList.this.linkLast(e);
            } else {
                LinkedList.this.linkBefore(e, this.next);
            }
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            while (LinkedList.this.modCount == this.expectedModCount && this.nextIndex < LinkedList.this.size) {
                action.accept(this.next.item);
                this.lastReturned = this.next;
                this.next = this.next.next;
                ++this.nextIndex;
            }
            this.checkForComodification();
        }

        final void checkForComodification() {
            if (LinkedList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Node<E> {
        E item;
        Node<E> next;
        Node<E> prev;

        Node(Node<E> prev, E element, Node<E> next) {
            this.item = element;
            this.next = next;
            this.prev = prev;
        }
    }
}

