/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@I
public class ArrayDeque<E>
extends AbstractCollection<E>
implements Deque<E>,
Cloneable,
Serializable {
    transient Object[] elements;
    transient int head;
    transient int tail;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final long serialVersionUID = 2340985798034038923L;

    private void allocateElements(int n) {
        int n2 = 8;
        if (n >= n2) {
            n2 = n;
            n2 |= n2 >>> 1;
            n2 |= n2 >>> 2;
            n2 |= n2 >>> 4;
            n2 |= n2 >>> 8;
            n2 |= n2 >>> 16;
            if (++n2 < 0) {
                n2 >>>= 1;
            }
        }
        this.elements = new Object[n2];
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int n = this.head;
        int n2 = this.elements.length;
        int n3 = n2 - n;
        int n4 = n2 << 1;
        if (n4 < 0) {
            throw new IllegalStateException("Sorry, deque too big");
        }
        Object[] objectArray = new Object[n4];
        System.arraycopy(this.elements, n, objectArray, 0, n3);
        System.arraycopy(this.elements, 0, objectArray, n3, n);
        this.elements = objectArray;
        this.head = 0;
        this.tail = n2;
    }

    private <T> T[] copyElements(T[] TArray) {
        if (this.head < this.tail) {
            System.arraycopy(this.elements, this.head, TArray, 0, this.size());
        } else if (this.head > this.tail) {
            int n = this.elements.length - this.head;
            System.arraycopy(this.elements, this.head, TArray, 0, n);
            System.arraycopy(this.elements, 0, TArray, n, this.tail);
        }
        return TArray;
    }

    public ArrayDeque() {
        this.elements = new Object[16];
    }

    public ArrayDeque(int n) {
        this.allocateElements(n);
    }

    public @PolyRead ArrayDeque(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead Collection<? extends E> collection) {
        this.allocateElements(collection.size());
        this.addAll(collection);
    }

    @Override
    public void addFirst(@Mutable ArrayDeque<E> this, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.head = this.head - 1 & this.elements.length - 1;
        this.elements[this.head] = e;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    @Override
    public void addLast(@Mutable ArrayDeque<E> this, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.elements[this.tail] = e;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    @Override
    public boolean offerFirst(@Mutable ArrayDeque<E> this, E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(@Mutable ArrayDeque<E> this, E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst(@Mutable ArrayDeque<E> this) {
        E e = this.pollFirst();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E removeLast(@Mutable ArrayDeque<E> this) {
        E e = this.pollLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public @Nullable E pollFirst(@Mutable ArrayDeque<E> this) {
        int n = this.head;
        Object object = this.elements[n];
        if (object == null) {
            return null;
        }
        this.elements[n] = null;
        this.head = n + 1 & this.elements.length - 1;
        return (E)object;
    }

    @Override
    public @Nullable E pollLast(@Mutable ArrayDeque<E> this) {
        int n = this.tail - 1 & this.elements.length - 1;
        Object object = this.elements[n];
        if (object == null) {
            return null;
        }
        this.elements[n] = null;
        this.tail = n;
        return (E)object;
    }

    @Override
    public E getFirst(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this) {
        Object object = this.elements[this.head];
        if (object == null) {
            throw new NoSuchElementException();
        }
        return (E)object;
    }

    @Override
    public E getLast(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this) {
        Object object = this.elements[this.tail - 1 & this.elements.length - 1];
        if (object == null) {
            throw new NoSuchElementException();
        }
        return (E)object;
    }

    @Override
    public @Nullable E peekFirst(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this) {
        return (E)this.elements[this.head];
    }

    @Override
    public @Nullable E peekLast(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this) {
        return (E)this.elements[this.tail - 1 & this.elements.length - 1];
    }

    @Override
    public boolean removeFirstOccurrence(@Mutable ArrayDeque<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        Object object2;
        if (object == null) {
            return false;
        }
        int n = this.elements.length - 1;
        int n2 = this.head;
        while ((object2 = this.elements[n2]) != null) {
            if (object.equals(object2)) {
                this.delete(n2);
                return true;
            }
            n2 = n2 + 1 & n;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(@Mutable ArrayDeque<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        Object object2;
        if (object == null) {
            return false;
        }
        int n = this.elements.length - 1;
        int n2 = this.tail - 1 & n;
        while ((object2 = this.elements[n2]) != null) {
            if (object.equals(object2)) {
                this.delete(n2);
                return true;
            }
            n2 = n2 - 1 & n;
        }
        return false;
    }

    @Override
    public boolean add(@Mutable ArrayDeque<E> this, E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(@Mutable ArrayDeque<E> this, E e) {
        return this.offerLast(e);
    }

    @Override
    public E remove(@Mutable ArrayDeque<E> this) {
        return this.removeFirst();
    }

    @Override
    public @Nullable E poll(@Mutable ArrayDeque<E> this) {
        return this.pollFirst();
    }

    @Override
    public E element(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this) {
        return this.getFirst();
    }

    @Override
    public @Nullable E peek(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this) {
        return this.peekFirst();
    }

    @Override
    public void push(@Mutable ArrayDeque<E> this, E e) {
        this.addFirst(e);
    }

    @Override
    public E pop(@Mutable ArrayDeque<E> this) {
        return this.removeFirst();
    }

    private void checkInvariants() {
        assert (this.elements[this.tail] == null);
        assert (this.head != this.tail ? this.elements[this.head] != null && this.elements[this.tail - 1 & this.elements.length - 1] != null : this.elements[this.head] == null);
        assert (this.elements[this.head - 1 & this.elements.length - 1] == null);
    }

    private boolean delete(int n) {
        this.checkInvariants();
        Object[] objectArray = this.elements;
        int n2 = objectArray.length - 1;
        int n3 = this.head;
        int n4 = this.tail;
        int n5 = n - n3 & n2;
        int n6 = n4 - n & n2;
        if (n5 >= (n4 - n3 & n2)) {
            throw new ConcurrentModificationException();
        }
        if (n5 < n6) {
            if (n3 <= n) {
                System.arraycopy(objectArray, n3, objectArray, n3 + 1, n5);
            } else {
                System.arraycopy(objectArray, 0, objectArray, 1, n);
                objectArray[0] = objectArray[n2];
                System.arraycopy(objectArray, n3, objectArray, n3 + 1, n2 - n3);
            }
            objectArray[n3] = null;
            this.head = n3 + 1 & n2;
            return false;
        }
        if (n < n4) {
            System.arraycopy(objectArray, n + 1, objectArray, n, n6);
            this.tail = n4 - 1;
        } else {
            System.arraycopy(objectArray, n + 1, objectArray, n, n2 - n);
            objectArray[n2] = objectArray[0];
            System.arraycopy(objectArray, 1, objectArray, 0, n4);
            this.tail = n4 - 1 & n2;
        }
        return true;
    }

    @Override
    @Pure
    public int size(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this) {
        return this.tail - this.head & this.elements.length - 1;
    }

    @Override
    @EnsuresNonNullIf(result=false, expression={"peek()", "peekFirst()", "peekLast()", "poll()", "pollFirst()", "pollLast()"})
    @Pure
    public boolean isEmpty(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this) {
        return this.head == this.tail;
    }

    @Override
    public @I @PolyRead Iterator<E> iterator(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this) {
        return new DeqIterator(this, null);
    }

    @Override
    public @I @PolyRead Iterator<E> descendingIterator(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this) {
        return new DescendingIterator(this, null);
    }

    @Override
    @Pure
    public boolean contains(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        Object object2;
        if (object == null) {
            return false;
        }
        int n = this.elements.length - 1;
        int n2 = this.head;
        while ((object2 = this.elements[n2]) != null) {
            if (object.equals(object2)) {
                return true;
            }
            n2 = n2 + 1 & n;
        }
        return false;
    }

    @Override
    public boolean remove(@Mutable ArrayDeque<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        return this.removeFirstOccurrence(object);
    }

    @Override
    public void clear(@Mutable ArrayDeque<E> this) {
        int n = this.head;
        int n2 = this.tail;
        if (n != n2) {
            this.tail = 0;
            this.head = 0;
            int n3 = n;
            int n4 = this.elements.length - 1;
            do {
                this.elements[n3] = null;
            } while ((n3 = n3 + 1 & n4) != n2);
        }
    }

    @Override
    public Object[] toArray(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this) {
        return this.copyElements(new Object[this.size()]);
    }

    @Override
    public <T> @Nullable T @PolyNull [] toArray(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this, T @PolyNull [] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        this.copyElements(objectArray);
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    @SideEffectFree
    public @I(value="N") ArrayDeque<E> clone() {
        try {
            ArrayDeque arrayDeque = (ArrayDeque)super.clone();
            arrayDeque.elements = Arrays.copyOf(this.elements, this.elements.length);
            return arrayDeque;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        int n = this.elements.length - 1;
        int n2 = this.head;
        while (n2 != this.tail) {
            objectOutputStream.writeObject(this.elements[n2]);
            n2 = n2 + 1 & n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.allocateElements(n);
        this.head = 0;
        this.tail = n;
        for (int i = 0; i < n; ++i) {
            this.elements[i] = objectInputStream.readObject();
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return new DeqSpliterator(-1, -1);
    }

    static /* synthetic */ boolean access$200(ArrayDeque arrayDeque, int n) {
        return arrayDeque.delete(n);
    }

    private class DeqIterator
    implements Iterator<E> {
        int cursor;
        int remaining;
        int lastRet;

        DeqIterator() {
            this.remaining = ArrayDeque.this.size();
            this.lastRet = -1;
            this.cursor = ArrayDeque.this.head;
        }

        @Override
        public final boolean hasNext() {
            return this.remaining > 0;
        }

        @Override
        public E next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            Object[] es = ArrayDeque.this.elements;
            Object e = ArrayDeque.nonNullElementAt((Object[])es, (int)this.cursor);
            this.lastRet = this.cursor;
            this.cursor = ArrayDeque.inc((int)this.lastRet, (int)es.length);
            --this.remaining;
            return e;
        }

        void postDelete(boolean leftShifted) {
            if (leftShifted) {
                this.cursor = ArrayDeque.dec((int)this.cursor, (int)ArrayDeque.this.elements.length);
            }
        }

        @Override
        public final void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.postDelete(ArrayDeque.this.delete(this.lastRet));
            this.lastRet = -1;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            int to;
            Objects.requireNonNull(action);
            int r = this.remaining;
            if (r <= 0) {
                return;
            }
            this.remaining = 0;
            Object[] es = ArrayDeque.this.elements;
            if (es[this.cursor] == null || ArrayDeque.sub((int)ArrayDeque.this.tail, (int)this.cursor, (int)es.length) != r) {
                throw new ConcurrentModificationException();
            }
            int i = this.cursor;
            int end = ArrayDeque.this.tail;
            int n = to = i <= end ? end : es.length;
            while (true) {
                if (i < to) {
                    action.accept(ArrayDeque.elementAt((Object[])es, (int)i));
                    ++i;
                    continue;
                }
                if (to == end) {
                    if (end != ArrayDeque.this.tail) {
                        throw new ConcurrentModificationException();
                    }
                    break;
                }
                i = 0;
                to = end;
            }
            this.lastRet = ArrayDeque.dec((int)end, (int)es.length);
        }
    }

    final class DeqSpliterator
    implements Spliterator<E> {
        private int fence;
        private int cursor;

        DeqSpliterator() {
            this.fence = -1;
        }

        DeqSpliterator(int origin, int fence) {
            this.cursor = origin;
            this.fence = fence;
        }

        private int getFence() {
            int t = this.fence;
            if (t < 0) {
                t = this.fence = ArrayDeque.this.tail;
                this.cursor = ArrayDeque.this.head;
            }
            return t;
        }

        public DeqSpliterator trySplit() {
            DeqSpliterator deqSpliterator;
            Object[] es = ArrayDeque.this.elements;
            int i = this.cursor;
            int n = ArrayDeque.sub((int)this.getFence(), (int)i, (int)es.length) >> 1;
            if (n <= 0) {
                deqSpliterator = null;
            } else {
                this.cursor = ArrayDeque.inc((int)i, (int)n, (int)es.length);
                DeqSpliterator deqSpliterator2 = new DeqSpliterator(i, this.cursor);
                deqSpliterator = deqSpliterator2;
            }
            return deqSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int end = this.getFence();
            int cursor = this.cursor;
            Object[] es = ArrayDeque.this.elements;
            if (cursor != end) {
                int to;
                this.cursor = end;
                if (es[cursor] == null || es[ArrayDeque.dec((int)end, (int)es.length)] == null) {
                    throw new ConcurrentModificationException();
                }
                int i = cursor;
                int n = to = i <= end ? end : es.length;
                while (true) {
                    if (i < to) {
                        action.accept(ArrayDeque.elementAt((Object[])es, (int)i));
                        ++i;
                        continue;
                    }
                    if (to == end) break;
                    i = 0;
                    to = end;
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            int i;
            Objects.requireNonNull(action);
            Object[] es = ArrayDeque.this.elements;
            if (this.fence < 0) {
                this.fence = ArrayDeque.this.tail;
                this.cursor = ArrayDeque.this.head;
            }
            if ((i = this.cursor) == this.fence) {
                return false;
            }
            Object e = ArrayDeque.nonNullElementAt((Object[])es, (int)i);
            this.cursor = ArrayDeque.inc((int)i, (int)es.length);
            action.accept(e);
            return true;
        }

        @Override
        public long estimateSize() {
            return ArrayDeque.sub((int)this.getFence(), (int)this.cursor, (int)ArrayDeque.this.elements.length);
        }

        @Override
        public int characteristics() {
            return 16720;
        }
    }

    private class DescendingIterator
    extends DeqIterator {
        DescendingIterator() {
            this.cursor = ArrayDeque.dec((int)ArrayDeque.this.tail, (int)ArrayDeque.this.elements.length);
        }

        @Override
        public final E next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            Object[] es = ArrayDeque.this.elements;
            Object e = ArrayDeque.nonNullElementAt((Object[])es, (int)this.cursor);
            this.lastRet = this.cursor;
            this.cursor = ArrayDeque.dec((int)this.lastRet, (int)es.length);
            --this.remaining;
            return e;
        }

        @Override
        void postDelete(boolean leftShifted) {
            if (!leftShifted) {
                this.cursor = ArrayDeque.inc((int)this.cursor, (int)ArrayDeque.this.elements.length);
            }
        }

        @Override
        public final void forEachRemaining(Consumer<? super E> action) {
            int to;
            Objects.requireNonNull(action);
            int r = this.remaining;
            if (r <= 0) {
                return;
            }
            this.remaining = 0;
            Object[] es = ArrayDeque.this.elements;
            if (es[this.cursor] == null || ArrayDeque.sub((int)this.cursor, (int)ArrayDeque.this.head, (int)es.length) + 1 != r) {
                throw new ConcurrentModificationException();
            }
            int i = this.cursor;
            int end = ArrayDeque.this.head;
            int n = to = i >= end ? end : 0;
            while (true) {
                if (i > to - 1) {
                    action.accept(ArrayDeque.elementAt((Object[])es, (int)i));
                    --i;
                    continue;
                }
                if (to == end) {
                    if (end != ArrayDeque.this.head) {
                        throw new ConcurrentModificationException();
                    }
                    break;
                }
                i = es.length - 1;
                to = end;
            }
            this.lastRet = end;
        }
    }
}

