/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class StringWriter
extends Writer {
    private StringBuffer buf;

    public StringWriter() {
        this.buf = new StringBuffer();
        this.lock = this.buf;
    }

    public StringWriter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.buf = new StringBuffer(n);
        this.lock = this.buf;
    }

    @Override
    public void write(int n) {
        this.buf.append((char)n);
    }

    @Override
    public void write(char @ReadOnly [] cArray, int n, int n2) {
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.buf.append(cArray, n, n2);
    }

    @Override
    public void write(String string) {
        this.buf.append(string);
    }

    @Override
    public void write(String string, int n, int n2) {
        this.buf.append(string.substring(n, n + n2));
    }

    @Override
    public StringWriter append(@Nullable @ReadOnly CharSequence charSequence) {
        if (charSequence == null) {
            this.write("null");
        } else {
            this.write(charSequence.toString());
        }
        return this;
    }

    @Override
    public StringWriter append(@Nullable @ReadOnly CharSequence charSequence, int n, int n2) {
        CharSequence charSequence2 = charSequence == null ? "null" : charSequence;
        this.write(charSequence2.subSequence(n, n2).toString());
        return this;
    }

    @Override
    public StringWriter append(char c) {
        this.write(c);
        return this;
    }

    @SideEffectFree
    public String toString(@ReadOnly StringWriter this) {
        return this.buf.toString();
    }

    public StringBuffer getBuffer(@ReadOnly StringWriter this) {
        return this.buf;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
    }
}

