/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.checkerframework.checker.igj.qual.Immutable;
import org.checkerframework.checker.igj.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@Immutable
public final class UUID
implements Serializable,
Comparable<UUID> {
    private static final long serialVersionUID = -4856846361193249489L;
    private final long mostSigBits;
    private final long leastSigBits;

    private UUID(byte[] byArray) {
        int n;
        long l = 0L;
        long l2 = 0L;
        assert (byArray.length == 16) : "data must be 16 bytes in length";
        for (n = 0; n < 8; ++n) {
            l = l << 8 | (long)(byArray[n] & 0xFF);
        }
        for (n = 8; n < 16; ++n) {
            l2 = l2 << 8 | (long)(byArray[n] & 0xFF);
        }
        this.mostSigBits = l;
        this.leastSigBits = l2;
    }

    public UUID(long l, long l2) {
        this.mostSigBits = l;
        this.leastSigBits = l2;
    }

    public static UUID randomUUID() {
        SecureRandom secureRandom = Holder.numberGenerator;
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        byArray[6] = (byte)(byArray[6] & 0xF);
        byArray[6] = (byte)(byArray[6] | 0x40);
        byArray[8] = (byte)(byArray[8] & 0x3F);
        byArray[8] = (byte)(byArray[8] | 0x80);
        return new UUID(byArray);
    }

    public static UUID nameUUIDFromBytes(byte @ReadOnly [] byArray) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("MD5 not supported", noSuchAlgorithmException);
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        byArray2[6] = (byte)(byArray2[6] & 0xF);
        byArray2[6] = (byte)(byArray2[6] | 0x30);
        byArray2[8] = (byte)(byArray2[8] & 0x3F);
        byArray2[8] = (byte)(byArray2[8] | 0x80);
        return new UUID(byArray2);
    }

    public static UUID fromString(String string) {
        String[] stringArray = string.split("-");
        if (stringArray.length != 5) {
            throw new IllegalArgumentException("Invalid UUID string: " + string);
        }
        for (int i = 0; i < 5; ++i) {
            stringArray[i] = "0x" + stringArray[i];
        }
        long l = Long.decode(stringArray[0]);
        l <<= 16;
        l |= Long.decode(stringArray[1]).longValue();
        l <<= 16;
        long l2 = Long.decode(stringArray[3]);
        l2 <<= 48;
        return new UUID(l |= Long.decode(stringArray[2]).longValue(), l2 |= Long.decode(stringArray[4]).longValue());
    }

    public long getLeastSignificantBits() {
        return this.leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.mostSigBits;
    }

    public int version() {
        return (int)(this.mostSigBits >> 12 & 0xFL);
    }

    public int variant() {
        return (int)(this.leastSigBits >>> (int)(64L - (this.leastSigBits >>> 62)) & this.leastSigBits >> 63);
    }

    public long timestamp() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        return (this.mostSigBits & 0xFFFL) << 48 | (this.mostSigBits >> 16 & 0xFFFFL) << 32 | this.mostSigBits >>> 32;
    }

    public int clockSequence() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        return (int)((this.leastSigBits & 0x3FFF000000000000L) >>> 48);
    }

    public long node() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        return this.leastSigBits & 0xFFFFFFFFFFFFL;
    }

    @SideEffectFree
    public String toString() {
        return UUID.digits(this.mostSigBits >> 32, 8) + "-" + UUID.digits(this.mostSigBits >> 16, 4) + "-" + UUID.digits(this.mostSigBits, 4) + "-" + UUID.digits(this.leastSigBits >> 48, 4) + "-" + UUID.digits(this.leastSigBits, 12);
    }

    private static String digits(long l, int n) {
        long l2 = 1L << n * 4;
        return Long.toHexString(l2 | l & l2 - 1L).substring(1);
    }

    @Pure
    public int hashCode() {
        long l = this.mostSigBits ^ this.leastSigBits;
        return (int)(l >> 32) ^ (int)l;
    }

    @Pure
    public boolean equals(@Nullable @ReadOnly Object object) {
        if (null == object || object.getClass() != UUID.class) {
            return false;
        }
        UUID uUID = (UUID)object;
        return this.mostSigBits == uUID.mostSigBits && this.leastSigBits == uUID.leastSigBits;
    }

    @Override
    @Pure
    public int compareTo(@ReadOnly UUID uUID) {
        return this.mostSigBits < uUID.mostSigBits ? -1 : (this.mostSigBits > uUID.mostSigBits ? 1 : (this.leastSigBits < uUID.leastSigBits ? -1 : (this.leastSigBits > uUID.leastSigBits ? 1 : 0)));
    }

    private static class Holder {
        static final SecureRandom numberGenerator = new SecureRandom();

        private Holder() {
        }
    }
}

