/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.checkerframework.checker.igj.qual.Immutable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;

@Immutable
public final class ServiceLoader<S>
implements Iterable<S> {
    private static final String PREFIX = "META-INF/services/";
    private final Class<S> service;
    private final ClassLoader loader;
    private final AccessControlContext acc;
    private LinkedHashMap<String, S> providers = new LinkedHashMap();
    private LazyIterator lookupIterator;

    public void reload() {
        this.providers.clear();
        this.lookupIterator = new LazyIterator(this, this.service, this.loader, null);
    }

    private ServiceLoader(Class<S> clazz, ClassLoader classLoader) {
        this.service = Objects.requireNonNull(clazz, "Service interface cannot be null");
        this.loader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        this.acc = System.getSecurityManager() != null ? AccessController.getContext() : null;
        this.reload();
    }

    private static void fail(Class<?> clazz, String string, Throwable throwable) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(clazz.getName() + ": " + string, throwable);
    }

    private static void fail(Class<?> clazz, String string) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(clazz.getName() + ": " + string);
    }

    private static void fail(Class<?> clazz, URL uRL, int n, String string) throws ServiceConfigurationError {
        ServiceLoader.fail(clazz, uRL + ":" + n + ": " + string);
    }

    private int parseLine(Class<?> clazz, URL uRL, BufferedReader bufferedReader, int n, List<String> list) throws IOException, ServiceConfigurationError {
        int n2;
        String string = bufferedReader.readLine();
        if (string == null) {
            return -1;
        }
        int n3 = string.indexOf(35);
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        if ((n2 = (string = string.trim()).length()) != 0) {
            int n4;
            if (string.indexOf(32) >= 0 || string.indexOf(9) >= 0) {
                ServiceLoader.fail(clazz, uRL, n, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(n4 = string.codePointAt(0))) {
                ServiceLoader.fail(clazz, uRL, n, "Illegal provider-class name: " + string);
            }
            for (int i = Character.charCount(n4); i < n2; i += Character.charCount(n4)) {
                n4 = string.codePointAt(i);
                if (Character.isJavaIdentifierPart(n4) || n4 == 46) continue;
                ServiceLoader.fail(clazz, uRL, n, "Illegal provider-class name: " + string);
            }
            if (!this.providers.containsKey(string) && !list.contains(string)) {
                list.add(string);
            }
        }
        return n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<String> parse(Class<?> clazz, URL uRL) throws ServiceConfigurationError {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            inputStream = uRL.openStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            int n = 1;
            while ((n = this.parseLine(clazz, uRL, bufferedReader, n, arrayList)) >= 0) {
            }
        }
        catch (IOException iOException) {
            ServiceLoader.fail(clazz, "Error reading configuration file", iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                ServiceLoader.fail(clazz, "Error closing configuration file", iOException);
            }
        }
        return arrayList.iterator();
    }

    @Override
    public @Immutable Iterator<S> iterator() {
        return new PrivilegedExceptionAction<Constructor<?>>(this){
            final /* synthetic */ Class val$clazz;
            {
                this.val$clazz = clazz;
            }

            @Override
            public Constructor<?> run() throws Exception {
                Constructor ctor = this.val$clazz.getConstructor(new Class[0]);
                if (ServiceLoader.this.inExplicitModule(this.val$clazz)) {
                    ctor.setAccessible(true);
                }
                return ctor;
            }
        };
    }

    public static <S> ServiceLoader<S> load(Class<S> clazz, @Nullable ClassLoader classLoader) {
        return new ServiceLoader<S>(clazz, classLoader);
    }

    public static <S> ServiceLoader<S> load(Class<S> clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return ServiceLoader.load(clazz, classLoader);
    }

    public static <S> ServiceLoader<S> loadInstalled(Class<S> clazz) {
        ClassLoader classLoader = null;
        for (ClassLoader classLoader2 = ClassLoader.getSystemClassLoader(); classLoader2 != null; classLoader2 = classLoader2.getParent()) {
            classLoader = classLoader2;
        }
        return ServiceLoader.load(clazz, classLoader);
    }

    @SideEffectFree
    public String toString() {
        return "java.util.ServiceLoader[" + this.service.getName() + "]";
    }

    static /* synthetic */ void access$100(Class clazz, String string, Throwable throwable) throws ServiceConfigurationError {
        ServiceLoader.fail(clazz, string, throwable);
    }

    static /* synthetic */ Iterator access$200(ServiceLoader serviceLoader, Class clazz, URL uRL) throws ServiceConfigurationError {
        return serviceLoader.parse(clazz, uRL);
    }

    static /* synthetic */ void access$300(Class clazz, String string) throws ServiceConfigurationError {
        ServiceLoader.fail(clazz, string);
    }

    static /* synthetic */ LinkedHashMap access$400(ServiceLoader serviceLoader) {
        return serviceLoader.providers;
    }

    static /* synthetic */ AccessControlContext access$500(ServiceLoader serviceLoader) {
        return serviceLoader.acc;
    }

    static /* synthetic */ LazyIterator access$800(ServiceLoader serviceLoader) {
        return serviceLoader.lookupIterator;
    }
}

