/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Objects;
import java.util.function.Consumer;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.igj.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Covariant;

@Covariant(value={0})
@I
public interface Iterator<E> {
    public boolean hasNext(@ReadOnly Iterator<E> this);

    public E next(@ReadOnly Iterator<E> this);

    default public void remove(@Mutable Iterator<E> this) {
        throw new UnsupportedOperationException("remove");
    }

    default public void forEachRemaining(Consumer<? super E> consumer) {
        Objects.requireNonNull(consumer);
        while (this.hasNext()) {
            consumer.accept(this.next());
        }
    }
}

